/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.Declarable;
import java.util.Arrays;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringContextBootstrappingInitializer
implements Declarable,
ApplicationListener<ContextRefreshedEvent> {
    public static final String BASE_PACKAGES_PARAMETER = "basePackages";
    public static final String CONTEXT_CONFIG_LOCATIONS_PARAMETER = "contextConfigLocations";
    protected static final String CHARS_TO_DELETE = " \n\t";
    protected static final String COMMA_DELIMITER = ",";
    static volatile ConfigurableApplicationContext applicationContext;
    private static final ApplicationEventMulticaster eventNotifier;
    private static ContextRefreshedEvent contextRefreshedEvent;

    public static synchronized ConfigurableApplicationContext getApplicationContext() {
        Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"The Spring ApplicationContext has not been created!");
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ApplicationListener<ContextRefreshedEvent>> T register(T listener) {
        ApplicationEventMulticaster applicationEventMulticaster = eventNotifier;
        synchronized (applicationEventMulticaster) {
            eventNotifier.addApplicationListener(listener);
            SpringContextBootstrappingInitializer.notifyListenerOfExistingContextRefreshedEvent(listener);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyListenerOfExistingContextRefreshedEvent(ApplicationListener<ContextRefreshedEvent> listener) {
        ApplicationEventMulticaster applicationEventMulticaster = eventNotifier;
        synchronized (applicationEventMulticaster) {
            if (applicationContext != null && contextRefreshedEvent != null) {
                listener.onApplicationEvent((ApplicationEvent)contextRefreshedEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ApplicationListener<ContextRefreshedEvent>> T unregister(T listener) {
        ApplicationEventMulticaster applicationEventMulticaster = eventNotifier;
        synchronized (applicationEventMulticaster) {
            eventNotifier.removeApplicationListener(listener);
        }
        return listener;
    }

    protected ConfigurableApplicationContext createApplicationContext(String[] configLocations) {
        Assert.notEmpty((Object[])configLocations, (String)"'configLocations' must be specified to construct an instance of the ClassPathXmlApplicationContext.");
        return this.createApplicationContext(null, configLocations);
    }

    protected ConfigurableApplicationContext createApplicationContext(String[] basePackages, String[] configLocations) {
        if (!ObjectUtils.isEmpty((Object[])configLocations)) {
            return new ClassPathXmlApplicationContext(configLocations, false);
        }
        Assert.notEmpty((Object[])basePackages, (String)"Either 'basePackages' or 'configLocations' must be specified to construct an instance of the ConfigurableApplicationContext.");
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.scan(basePackages);
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties parameters) {
        String basePackages = parameters.getProperty(BASE_PACKAGES_PARAMETER);
        String contextConfigLocations = parameters.getProperty(CONTEXT_CONFIG_LOCATIONS_PARAMETER);
        Assert.isTrue((StringUtils.hasText((String)basePackages) || StringUtils.hasText((String)contextConfigLocations) ? 1 : 0) != 0, (String)"Either 'basePackages' or the 'contextConfigLocations' parameter must be specified.");
        Object[] basePackagesArray = StringUtils.delimitedListToStringArray((String)basePackages, (String)COMMA_DELIMITER, (String)CHARS_TO_DELETE);
        Object[] configLocations = StringUtils.delimitedListToStringArray((String)contextConfigLocations, (String)COMMA_DELIMITER, (String)CHARS_TO_DELETE);
        Class<SpringContextBootstrappingInitializer> clazz = SpringContextBootstrappingInitializer.class;
        synchronized (SpringContextBootstrappingInitializer.class) {
            Assert.state((applicationContext == null ? 1 : 0) != 0, (String)String.format("A Spring application context with ID (%1$s) has already been created.", this.nullSafeGetApplicationContextId((ApplicationContext)applicationContext)));
            applicationContext = this.createApplicationContext((String[])basePackagesArray, (String[])configLocations);
            Assert.notNull((Object)applicationContext, (String)"The 'created' ConfigurableApplicationContext cannot be null!");
            assert (applicationContext != null);
            applicationContext.addApplicationListener((ApplicationListener)this);
            applicationContext.registerShutdownHook();
            applicationContext.refresh();
            Assert.state((boolean)applicationContext.isActive(), (String)String.format("The Spring application context (%1$s) has failed to be properly initialized with the following config files (%2$s) or base packages (%3$s)!", this.nullSafeGetApplicationContextId((ApplicationContext)applicationContext), Arrays.toString(configLocations), Arrays.toString(basePackagesArray)));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    protected String nullSafeGetApplicationContextId(ApplicationContext applicationContext) {
        return applicationContext != null ? applicationContext.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationEventMulticaster applicationEventMulticaster = eventNotifier;
        synchronized (applicationEventMulticaster) {
            contextRefreshedEvent = event;
            eventNotifier.multicastEvent((ApplicationEvent)event);
        }
    }

    static {
        eventNotifier = new SimpleApplicationEventMulticaster();
    }
}

