/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.Declarable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.support.SpringContextBootstrappingInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class LazyWiringDeclarableSupport
implements ApplicationListener<ContextRefreshedEvent>,
Declarable,
DisposableBean {
    protected static final String BEAN_NAME_PARAMETER = "bean-name";
    private final AtomicReference<Properties> parametersReference = new AtomicReference();
    protected volatile boolean initialized = false;

    public LazyWiringDeclarableSupport() {
        SpringContextBootstrappingInitializer.register(this);
    }

    protected void assertInitialized() {
        Assert.state((boolean)this.isInitialized(), (String)String.format("This Declarable object (%1$s) has not ben properly configured and initialized!", this.getClass().getName()));
    }

    void doInit(ConfigurableListableBeanFactory beanFactory, Properties parameters) {
        BeanConfigurerSupport beanConfigurer = new BeanConfigurerSupport();
        beanConfigurer.setBeanFactory((BeanFactory)beanFactory);
        final String templateBeanName = parameters.getProperty(BEAN_NAME_PARAMETER);
        if (StringUtils.hasText((String)templateBeanName)) {
            if (beanFactory.containsBean(templateBeanName)) {
                beanConfigurer.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

                    public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
                        return new BeanWiringInfo(templateBeanName);
                    }
                });
            } else {
                throw new IllegalArgumentException(String.format("No bean with name '%1$s' was found in the Spring context '%2$s'.", templateBeanName, beanFactory));
            }
        }
        beanConfigurer.afterPropertiesSet();
        beanConfigurer.configureBean((Object)this);
        beanConfigurer.destroy();
        this.initialized = true;
        this.doPostInit(parameters);
    }

    protected void doPostInit(Properties parameters) {
    }

    public final void init(Properties parameters) {
        Assert.state((boolean)this.parametersReference.compareAndSet(null, parameters), (String)String.format("This Declarable (%1$s) has already been initialized.", this.getClass().getName()));
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        Properties parameters = this.parametersReference.get();
        Assert.state((parameters != null ? 1 : 0) != 0, (String)String.format("This Declarable object's (%1$s) init method has not been invoked!", this.getClass().getName()));
        Assert.isTrue((boolean)(event.getApplicationContext() instanceof ConfigurableApplicationContext), (String)String.format("The Spring ApplicationContext (%1$s) must be an instance of ConfigurableApplicationContext.", ObjectUtils.nullSafeClassName((Object)event.getApplicationContext())));
        this.doInit(((ConfigurableApplicationContext)event.getApplicationContext()).getBeanFactory(), parameters);
    }

    public void destroy() throws Exception {
        SpringContextBootstrappingInitializer.unregister(this);
    }
}

