/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PartitionAttributesFactoryBean
implements FactoryBean<PartitionAttributes>,
InitializingBean {
    private final PartitionAttributesFactory paf = new PartitionAttributesFactory();
    private List<PartitionListener> listeners;

    public PartitionAttributes getObject() throws Exception {
        return this.paf.create();
    }

    public Class<?> getObjectType() {
        return PartitionAttributes.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setColocatedWith(String colocatedRegionFullPath) {
        this.paf.setColocatedWith(colocatedRegionFullPath);
    }

    public void setFixedPartitionAttributes(List<FixedPartitionAttributes> fixedPartitionAttributes) {
        for (FixedPartitionAttributes fpa : fixedPartitionAttributes) {
            this.paf.addFixedPartitionAttributes(fpa);
        }
    }

    public void setLocalMaxMemory(int mb) {
        this.paf.setLocalMaxMemory(mb);
    }

    public void setPartitionResolver(PartitionResolver resolver) {
        this.paf.setPartitionResolver(resolver);
    }

    public void setPartitionListeners(List<PartitionListener> listeners) {
        this.listeners = listeners;
    }

    public void setRecoveryDelay(long recoveryDelay) {
        this.paf.setRecoveryDelay(recoveryDelay);
    }

    public void setRedundantCopies(int redundantCopies) {
        this.paf.setRedundantCopies(redundantCopies);
    }

    public void setStartupRecoveryDelay(long startupRecoveryDelay) {
        this.paf.setStartupRecoveryDelay(startupRecoveryDelay);
    }

    public void setTotalMaxMemory(long mb) {
        this.paf.setTotalMaxMemory(mb);
    }

    public void setTotalNumBuckets(int numBuckets) {
        this.paf.setTotalNumBuckets(numBuckets);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.listeners != null) {
            for (PartitionListener listener : this.listeners) {
                this.paf.addPartitionListener(listener);
            }
        }
    }
}

