/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class AbstractRegionParser
extends AbstractSingleBeanDefinitionParser {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    AbstractRegionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return this.getRegionFactoryClass();
    }

    protected abstract Class<?> getRegionFactoryClass();

    protected boolean isSubRegion(Element element) {
        String localName = element.getParentNode().getLocalName();
        return localName != null && localName.endsWith("region");
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        boolean subRegion = this.isSubRegion(element);
        this.doParseRegion(element, parserContext, builder, subRegion);
    }

    protected abstract void doParseRegion(Element var1, ParserContext var2, BeanDefinitionBuilder var3, boolean var4);

    protected void doParseCommonRegionConfiguration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinitionBuilder regionAttributesBuilder, boolean subRegion) {
        String resolvedCacheRef = ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref"));
        if (!subRegion) {
            builder.addPropertyReference("cache", resolvedCacheRef);
            ParsingUtils.setPropertyValue(element, builder, "close");
            ParsingUtils.setPropertyValue(element, builder, "destroy");
        }
        ParsingUtils.setPropertyValue(element, builder, "name");
        ParsingUtils.setPropertyValue(element, builder, "ignore-if-exists", "lookupEnabled");
        ParsingUtils.setPropertyValue(element, builder, "data-policy");
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        ParsingUtils.setPropertyValue(element, builder, "shortcut");
        if (StringUtils.hasText((String)element.getAttribute("disk-store-ref"))) {
            ParsingUtils.setPropertyValue(element, builder, "disk-store-ref", "diskStoreName");
            builder.addDependsOn(element.getAttribute("disk-store-ref"));
        }
        ParsingUtils.parseOptionalRegionAttributes(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseSubscription(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseStatistics(element, regionAttributesBuilder);
        ParsingUtils.parseExpiration(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseEviction(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseMembershipAttributes(parserContext, element, regionAttributesBuilder);
        String enableGateway = element.getAttribute("enable-gateway");
        String hubId = element.getAttribute("hub-id");
        if (StringUtils.hasText((String)enableGateway) && GemfireUtils.isGemfireVersion7OrAbove()) {
            this.log.warn((Object)"'enable-gateway' is deprecated since Gemfire 7.0");
        }
        ParsingUtils.setPropertyValue(element, builder, "enable-gateway");
        if (StringUtils.hasText((String)hubId)) {
            if (GemfireUtils.isGemfireVersion7OrAbove()) {
                this.log.warn((Object)"'hub-id' is deprecated since Gemfire 7.0");
            }
            if (!CollectionUtils.isEmpty((Collection)DomUtils.getChildElementsByTagName((Element)element, (String)"gateway-sender"))) {
                parserContext.getReaderContext().error("It is invalid to specify both 'hub-id' and 'gateway-sender'", (Object)element);
            }
        }
        ParsingUtils.setPropertyValue(element, builder, "hub-id");
        this.parseCollectionOfCustomSubElements(element, parserContext, builder, "com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue", "async-event-queue", "asyncEventQueues");
        this.parseCollectionOfCustomSubElements(element, parserContext, builder, "com.gemstone.gemfire.cache.wan.GatewaySender", "gateway-sender", "gatewaySenders");
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            if (subElement.getLocalName().equals("cache-listener")) {
                builder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if (subElement.getLocalName().equals("cache-loader")) {
                builder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
                continue;
            }
            if (!subElement.getLocalName().equals("cache-writer")) continue;
            builder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder));
        }
        if (!subRegion) {
            this.parseSubRegions(element, parserContext, resolvedCacheRef);
        }
    }

    private void parseCollectionOfCustomSubElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String className, String subElementName, String propertyName) {
        List subElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{subElementName, subElementName + "-ref"});
        if (!CollectionUtils.isEmpty((Collection)subElements)) {
            ManagedArray array = new ManagedArray(className, subElements.size());
            for (Element subElement : subElements) {
                array.add(ParsingUtils.parseRefOrNestedCustomElement(parserContext, subElement, builder));
            }
            builder.addPropertyValue(propertyName, (Object)array);
        }
    }

    protected void parseSubRegions(Element element, ParserContext parserContext, String resolvedCacheRef) {
        HashMap<String, Element> allSubRegionElements = new HashMap<String, Element>();
        this.findSubRegionElements(element, this.getRegionNameFromElement(element), allSubRegionElements);
        if (!CollectionUtils.isEmpty(allSubRegionElements)) {
            for (Map.Entry entry : allSubRegionElements.entrySet()) {
                this.parseSubRegion((Element)entry.getValue(), parserContext, (String)entry.getKey(), resolvedCacheRef);
            }
        }
    }

    private void findSubRegionElements(Element parent, String parentPath, Map<String, Element> allSubRegionElements) {
        for (Element element : DomUtils.getChildElements((Element)parent)) {
            if (!element.getLocalName().endsWith("region")) continue;
            String subRegionName = this.getRegionNameFromElement(element);
            String subRegionPath = this.buildSubRegionPath(parentPath, subRegionName);
            allSubRegionElements.put(subRegionPath, element);
            this.findSubRegionElements(element, subRegionPath, allSubRegionElements);
        }
    }

    private String getRegionNameFromElement(Element element) {
        String name = element.getAttribute("name");
        return StringUtils.hasText((String)name) ? name : element.getAttribute("id");
    }

    private String buildSubRegionPath(String parentName, String regionName) {
        String regionPath = StringUtils.arrayToDelimitedString((Object[])new String[]{parentName, regionName}, (String)"/");
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        return regionPath;
    }

    private BeanDefinition parseSubRegion(Element element, ParserContext parserContext, String subRegionPath, String cacheRef) {
        String parentBeanName = this.getParentRegionPathFrom(subRegionPath);
        String regionName = this.getRegionNameFromElement(element);
        element.setAttribute("id", subRegionPath);
        element.setAttribute("name", subRegionPath);
        BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(element);
        beanDefinition.getPropertyValues().add("cache", (Object)new RuntimeBeanReference(cacheRef));
        beanDefinition.getPropertyValues().add("parent", (Object)new RuntimeBeanReference(parentBeanName));
        beanDefinition.getPropertyValues().add("regionName", (Object)regionName);
        return beanDefinition;
    }

    private String getParentRegionPathFrom(String regionPath) {
        int index = regionPath.lastIndexOf("/");
        String parentPath = regionPath.substring(0, index);
        if (parentPath.lastIndexOf("/") == 0) {
            parentPath = parentPath.substring(1);
        }
        return parentPath;
    }

    protected void validateDataPolicyShortcutAttributesMutualExclusion(Element element, ParserContext parserContext) {
        if (element.hasAttribute("data-policy") && element.hasAttribute("shortcut")) {
            parserContext.getReaderContext().error(String.format("Only one of [data-policy, shortcut] may be specified with element '%1$s'.", element.getTagName()), (Object)element);
        }
    }
}

