/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.config.SubscriptionType;

public class SubscriptionAttributesFactoryBean
implements FactoryBean<SubscriptionAttributes>,
InitializingBean {
    SubscriptionAttributes subscriptionAttri;
    InterestPolicy policy;
    SubscriptionType type = SubscriptionType.ALL;

    public void afterPropertiesSet() throws Exception {
        if (this.policy == null) {
            this.policy = InterestPolicy.DEFAULT;
        }
        this.subscriptionAttri = this.createAttributes();
    }

    private SubscriptionAttributes createAttributes() {
        switch (this.type) {
            case ALL: {
                this.policy = InterestPolicy.ALL;
                break;
            }
            case CACHE_CONTENT: {
                this.policy = InterestPolicy.CACHE_CONTENT;
                break;
            }
            default: {
                this.policy = InterestPolicy.DEFAULT;
            }
        }
        return new SubscriptionAttributes(this.policy);
    }

    public SubscriptionAttributes getObject() throws Exception {
        return this.subscriptionAttri;
    }

    public Class<?> getObjectType() {
        return this.subscriptionAttri != null ? this.subscriptionAttri.getClass() : SubscriptionAttributes.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public InterestPolicy getPolicy() {
        return this.policy;
    }

    public SubscriptionType getType() {
        return this.type;
    }

    public void setPolicy(InterestPolicy policy) {
        this.policy = policy;
    }

    public void setType(SubscriptionType type) {
        this.type = type;
    }
}

