/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractFunctionExecution {
    private static final String NO_RESULT_MESSAGE = "Cannot return any result as the Function#hasResult() is false";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile ResultCollector<?, ?> resultCollector;
    private Object[] args;
    private Function function;
    private String functionId;
    private long timeout;

    public AbstractFunctionExecution(Function function, Object ... args) {
        Assert.notNull((Object)function, (String)"function cannot be null");
        this.function = function;
        this.functionId = function.getId();
        this.args = args;
    }

    public AbstractFunctionExecution(String functionId, Object ... args) {
        Assert.isTrue((boolean)StringUtils.hasLength((String)functionId), (String)"functionId cannot be null or empty");
        this.functionId = functionId;
        this.args = args;
    }

    AbstractFunctionExecution() {
    }

    ResultCollector<?, ?> getCollector() {
        return this.resultCollector;
    }

    Object[] getArgs() {
        return this.args;
    }

    String getFunctionId() {
        return this.functionId;
    }

    Function getFunction() {
        return this.function;
    }

    long getTimeout() {
        return this.timeout;
    }

    <T> Iterable<T> execute() {
        return this.execute(true);
    }

    <T> Iterable<T> execute(Boolean returnResult) {
        Execution execution = this.getExecution();
        if (this.getKeys() != null) {
            execution = execution.withFilter(this.getKeys());
        }
        if (this.getCollector() != null) {
            execution = execution.withCollector(this.getCollector());
        }
        ResultCollector resultCollector = null;
        execution = execution.withArgs((Object)this.getArgs());
        if (this.isRegisteredFunction()) {
            resultCollector = execution.execute(this.functionId);
        } else {
            resultCollector = execution.execute(this.function);
            if (!this.function.hasResult()) {
                return null;
            }
        }
        if (!returnResult.booleanValue()) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("using ResultsCollector:" + resultCollector.getClass().getName()));
        }
        Iterable results = null;
        try {
            if (this.timeout > 0L) {
                try {
                    results = (Iterable)resultCollector.getResult(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (FunctionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                results = (Iterable)resultCollector.getResult();
            }
            return this.replaceSingletonNullCollectionWithEmptyList(results);
        }
        catch (FunctionException e) {
            if (!e.getMessage().equals(NO_RESULT_MESSAGE)) {
                throw e;
            }
            return results;
        }
    }

    <T> T executeAndExtract() {
        Iterable<T> results = this.execute();
        if (results == null || !results.iterator().hasNext()) {
            return null;
        }
        return results.iterator().next();
    }

    protected abstract Execution getExecution();

    protected AbstractFunctionExecution setFunctionId(String functionId) {
        this.functionId = functionId;
        return this;
    }

    protected AbstractFunctionExecution setFunction(Function function) {
        this.function = function;
        return this;
    }

    protected AbstractFunctionExecution setArgs(Object ... args) {
        this.args = args;
        return this;
    }

    protected Set<?> getKeys() {
        return null;
    }

    protected AbstractFunctionExecution setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    protected AbstractFunctionExecution setResultCollector(ResultCollector<?, ?> resultCollector) {
        this.resultCollector = resultCollector;
        return this;
    }

    private boolean isRegisteredFunction() {
        return this.function == null;
    }

    private <T> Iterable<T> replaceSingletonNullCollectionWithEmptyList(Iterable<T> results) {
        if (results == null) {
            return results;
        }
        Iterator<T> it = results.iterator();
        if (!it.hasNext()) {
            return results;
        }
        if (it.next() == null && !it.hasNext()) {
            return new ArrayList();
        }
        return results;
    }
}

