/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import java.util.List;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GatewayReceiverFactoryBean
extends AbstractWANComponentFactoryBean<GatewayReceiver> {
    private GatewayReceiver gatewayReceiver;
    private List<GatewayTransportFilter> transportFilters;
    private Integer startPort;
    private Integer endPort;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private String bindAddress;

    public GatewayReceiverFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    public GatewayReceiver getObject() throws Exception {
        return this.gatewayReceiver;
    }

    @Override
    public Class<?> getObjectType() {
        return GatewayReceiver.class;
    }

    @Override
    protected void doInit() throws Exception {
        GatewayReceiverFactory gatewayReceiverFactory = this.cache.createGatewayReceiverFactory();
        if (!CollectionUtils.isEmpty(this.transportFilters)) {
            for (GatewayTransportFilter transportFilter : this.transportFilters) {
                gatewayReceiverFactory.addGatewayTransportFilter(transportFilter);
            }
        }
        int minPort = this.startPort == null ? 5000 : this.startPort;
        int maxPort = this.endPort == null ? 5500 : this.endPort;
        Assert.isTrue((minPort <= maxPort ? 1 : 0) != 0, (String)("startPort must be less then or equal to " + maxPort));
        gatewayReceiverFactory.setStartPort(minPort);
        gatewayReceiverFactory.setEndPort(maxPort);
        if (this.socketBufferSize != null) {
            gatewayReceiverFactory.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        if (this.maximumTimeBetweenPings != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(this.maximumTimeBetweenPings.intValue());
        }
        if (this.bindAddress != null) {
            gatewayReceiverFactory.setBindAddress(this.bindAddress);
        }
        this.gatewayReceiver = gatewayReceiverFactory.create();
        this.gatewayReceiver.start();
    }

    public void setGatewayReceiver(GatewayReceiver gatewayReceiver) {
        this.gatewayReceiver = gatewayReceiver;
    }

    public void setTransportFilters(List<GatewayTransportFilter> transportFilters) {
        this.transportFilters = transportFilters;
    }

    public void setStartPort(Integer startPort) {
        this.startPort = startPort;
    }

    public void setEndPort(Integer endPort) {
        this.endPort = endPort;
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }
}

