/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.io.File;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.gemfire.DiskStoreFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DiskStoreBeanPostProcessor
implements BeanPostProcessor {
    protected final Log log = LogFactory.getLog(this.getClass());

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Post Processing Bean (%1$s) of Type (%2$s) with Name (%3$s)...%n", bean, ObjectUtils.nullSafeClassName((Object)bean), beanName));
        }
        if (bean instanceof DiskStoreFactoryBean.DiskDir) {
            this.createIfNotExists((DiskStoreFactoryBean.DiskDir)bean);
        }
        return bean;
    }

    private void createIfNotExists(DiskStoreFactoryBean.DiskDir diskDirectory) {
        String location = (String)this.readField(diskDirectory, "location");
        File diskDirectoryFile = new File(location);
        Assert.isTrue((diskDirectoryFile.isDirectory() || diskDirectoryFile.mkdirs() ? 1 : 0) != 0, (String)String.format("Failed to create Disk Directory (%1$s)%n!", location));
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("The Disk Directory either exists or was created @ Location (%1$s).%n", location));
        }
    }

    private <T> T readField(Object obj, String fieldName) {
        try {
            Field field;
            Class<?> type = obj.getClass();
            do {
                field = type.getDeclaredField(fieldName);
                type = type.getSuperclass();
            } while (field == null && !Object.class.equals(type));
            if (field == null) {
                throw new NoSuchFieldException(String.format("Field (%1$s) does not exist on Object of type (%2$s)!", fieldName, ObjectUtils.nullSafeClassName((Object)obj)));
            }
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to read field (%1$s) on Object of type (%2$s)!", fieldName, ObjectUtils.nullSafeClassName((Object)obj)), e);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

