/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EnumSerializer
extends DataSerializer
implements Serializable {
    private static final long serialVersionUID = -7069461993489626976L;
    private static final ConcurrentMap<Class<?>, Enum[]> supportedClasses = new ConcurrentHashMap();
    private int id = 1024;

    public boolean toData(Object o, DataOutput out) throws IOException {
        if (o instanceof Enum) {
            Enum enm = (Enum)o;
            Class cls = enm.getDeclaringClass();
            this.addEnum(cls);
            DataSerializer.writeClass(cls, (DataOutput)out);
            out.writeInt(enm.ordinal());
        }
        return false;
    }

    public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
        Class cls = DataSerializer.readClass((DataInput)in);
        if (cls.isEnum()) {
            this.addEnum(cls);
            int ordinal = in.readInt();
            return ((Enum[])supportedClasses.get(cls))[ordinal];
        }
        throw new IOException("Non-enum class read from the stream -" + cls);
    }

    public void addEnum(Class enumClass) {
        if (!supportedClasses.containsKey(enumClass)) {
            supportedClasses.put(enumClass, (Enum[])enumClass.getEnumConstants());
        }
        if (InternalDataSerializer.getSerializer((int)this.getId()) != null && InternalDataSerializer.getSerializer((Class)enumClass) == null) {
            InternalDataSerializer.unregister((int)this.getId());
            InternalDataSerializer.register(this.getClass());
        }
    }

    public Class<?>[] getSupportedClasses() {
        return supportedClasses.keySet().toArray(new Class[supportedClasses.size()]);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

