/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import java.util.List;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.data.gemfire.wan.GatewaySenderWrapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GatewaySenderFactoryBean
extends AbstractWANComponentFactoryBean<GatewaySender>
implements SmartLifecycle {
    private boolean manualStart = false;
    private int remoteDistributedSystemId;
    private GatewaySender gatewaySender;
    private List<GatewayEventFilter> eventFilters;
    private List<GatewayTransportFilter> transportFilters;
    private Boolean diskSynchronous;
    private Boolean batchConflationEnabled;
    private Boolean parallel;
    private Boolean persistent;
    private GatewayEventSubstitutionFilter eventSubstitutionFilter;
    private Integer alertThreshold;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;
    private String diskStoreReference;
    private String orderPolicy;

    public GatewaySenderFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    public GatewaySender getObject() throws Exception {
        return this.gatewaySender;
    }

    @Override
    public Class<?> getObjectType() {
        return this.gatewaySender != null ? this.gatewaySender.getClass() : GatewaySender.class;
    }

    @Override
    protected void doInit() {
        GatewaySenderFactory gatewaySenderFactory;
        GatewaySenderFactory gatewaySenderFactory2 = gatewaySenderFactory = this.factory != null ? (GatewaySenderFactory)this.factory : this.cache.createGatewaySenderFactory();
        if (this.alertThreshold != null) {
            gatewaySenderFactory.setAlertThreshold(this.alertThreshold.intValue());
        }
        if (this.batchSize != null) {
            gatewaySenderFactory.setBatchSize(this.batchSize.intValue());
        }
        if (this.batchTimeInterval != null) {
            gatewaySenderFactory.setBatchTimeInterval(this.batchTimeInterval.intValue());
        }
        if (this.diskStoreReference != null) {
            gatewaySenderFactory.setDiskStoreName(this.diskStoreReference);
        }
        if (this.diskSynchronous != null) {
            gatewaySenderFactory.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.dispatcherThreads != null) {
            gatewaySenderFactory.setDispatcherThreads(this.dispatcherThreads.intValue());
        }
        if (this.batchConflationEnabled != null) {
            gatewaySenderFactory.setBatchConflationEnabled(this.batchConflationEnabled.booleanValue());
        }
        if (!CollectionUtils.isEmpty(this.eventFilters)) {
            for (GatewayEventFilter eventFilter : this.eventFilters) {
                gatewaySenderFactory.addGatewayEventFilter(eventFilter);
            }
        }
        if (this.eventSubstitutionFilter != null) {
            gatewaySenderFactory.setGatewayEventSubstitutionFilter(this.eventSubstitutionFilter);
        }
        gatewaySenderFactory.setManualStart(true);
        if (this.maximumQueueMemory != null) {
            gatewaySenderFactory.setMaximumQueueMemory(this.maximumQueueMemory.intValue());
        }
        if (this.orderPolicy != null) {
            Assert.isTrue((boolean)this.isSerialGatewaySender(), (String)"Order Policy cannot be used with a Parallel Gateway Sender Queue.");
            Assert.isTrue((boolean)VALID_ORDER_POLICIES.contains(this.orderPolicy.toUpperCase()), (String)String.format("The value for Order Policy '%1$s' is invalid.", this.orderPolicy));
            gatewaySenderFactory.setOrderPolicy(Gateway.OrderPolicy.valueOf((String)this.orderPolicy.toUpperCase()));
        }
        gatewaySenderFactory.setParallel(this.isParallelGatewaySender());
        gatewaySenderFactory.setPersistenceEnabled(this.isPersistent());
        if (this.socketBufferSize != null) {
            gatewaySenderFactory.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        if (this.socketReadTimeout != null) {
            gatewaySenderFactory.setSocketReadTimeout(this.socketReadTimeout.intValue());
        }
        if (!CollectionUtils.isEmpty(this.transportFilters)) {
            for (GatewayTransportFilter transportFilter : this.transportFilters) {
                gatewaySenderFactory.addGatewayTransportFilter(transportFilter);
            }
        }
        GatewaySenderWrapper wrapper = new GatewaySenderWrapper(gatewaySenderFactory.create(this.getName(), this.remoteDistributedSystemId));
        wrapper.setManualStart(this.manualStart);
        this.gatewaySender = wrapper;
    }

    public void setAlertThreshold(Integer alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    @Deprecated
    public void setEnableBatchConflation(Boolean enableBatchConflation) {
        this.batchConflationEnabled = enableBatchConflation;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreReference = diskStoreRef;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setEventFilters(List<GatewayEventFilter> gatewayEventFilters) {
        this.eventFilters = gatewayEventFilters;
    }

    public void setEventSubstitutionFilter(GatewayEventSubstitutionFilter eventSubstitutionFilter) {
        this.eventSubstitutionFilter = eventSubstitutionFilter;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = Boolean.TRUE.equals(manualStart);
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setOrderPolicy(String orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isSerialGatewaySender() {
        return !this.isParallelGatewaySender();
    }

    public boolean isParallelGatewaySender() {
        return Boolean.TRUE.equals(this.parallel);
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isNotPersistent() {
        return !this.isPersistent();
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    public void setRemoteDistributedSystemId(int remoteDistributedSystemId) {
        this.remoteDistributedSystemId = remoteDistributedSystemId;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSocketReadTimeout(Integer socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    public void setTransportFilters(List<GatewayTransportFilter> gatewayTransportFilters) {
        this.transportFilters = gatewayTransportFilters;
    }

    public boolean isAutoStartup() {
        return !this.manualStart;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isRunning() {
        return this.gatewaySender.isRunning();
    }

    public synchronized void start() {
        Assert.notNull((Object)this.gatewaySender, (String)"The GatewaySender was not properly configured and initialized!");
        if (!this.isRunning()) {
            this.gatewaySender.start();
        }
    }

    public void stop() {
        this.gatewaySender.stop();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

