/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.internal.lang.ObjectUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;

public class GemFireCacheTypeAwareRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements BeanFactoryAware {
    private GemFireCache gemfireCache;
    private BeanFactory beanFactory;
    private Boolean close = false;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private ClientRegionShortcut clientRegionShortcut = ClientRegionShortcut.PROXY;
    private DataPolicy dataPolicy = DataPolicy.DEFAULT;
    private RegionAttributes<K, V> regionAttributes;
    private RegionShortcut serverRegionShortcut;
    private String poolName;
    private String regionName;

    @Override
    public Region<K, V> lookupRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        return GemfireUtils.isClient(gemfireCache) ? this.newClientRegion(gemfireCache, regionName) : this.newServerRegion(gemfireCache, regionName);
    }

    protected Region<K, V> newClientRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        ClientRegionFactoryBean<K, V> clientRegion = new ClientRegionFactoryBean<K, V>();
        clientRegion.setAttributes(this.getRegionAttributes());
        clientRegion.setBeanFactory(this.getBeanFactory());
        clientRegion.setCache(gemfireCache);
        clientRegion.setClose(this.isClose());
        clientRegion.setKeyConstraint(this.getKeyConstraint());
        clientRegion.setPoolName(this.getPoolName());
        clientRegion.setRegionName(regionName);
        clientRegion.setShortcut(this.getClientRegionShortcut());
        clientRegion.setValueConstraint(this.getValueConstraint());
        clientRegion.afterPropertiesSet();
        return clientRegion.getObject();
    }

    protected Region<K, V> newServerRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        GenericRegionFactoryBean<K, V> serverRegion = new GenericRegionFactoryBean<K, V>();
        serverRegion.setAttributes(this.getRegionAttributes());
        serverRegion.setCache(gemfireCache);
        serverRegion.setClose(this.isClose());
        serverRegion.setDataPolicy(this.getDataPolicy());
        serverRegion.setKeyConstraint(this.getKeyConstraint());
        serverRegion.setRegionName(regionName);
        serverRegion.setShortcut(this.getServerRegionShortcut());
        serverRegion.setValueConstraint(this.getValueConstraint());
        serverRegion.afterPropertiesSet();
        return serverRegion.getObject();
    }

    public void setAttributes(RegionAttributes<K, V> regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    protected RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory was not properly initialized");
        return this.beanFactory;
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return (ClientRegionShortcut)ObjectUtils.defaultIfNull((Object[])new ClientRegionShortcut[]{this.clientRegionShortcut, ClientRegionShortcut.PROXY});
    }

    public void setClose(Boolean close) {
        this.close = close;
    }

    protected Boolean getClose() {
        return this.close;
    }

    protected boolean isClose() {
        return Boolean.TRUE.equals(this.getClose());
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    protected DataPolicy getDataPolicy() {
        return (DataPolicy)ObjectUtils.defaultIfNull((Object[])new DataPolicy[]{this.dataPolicy, DataPolicy.DEFAULT});
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    protected Class<K> getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected String getPoolName() {
        return SpringUtils.defaultIfEmpty(this.poolName, "gemfirePool");
    }

    public void setServerRegionShortcut(RegionShortcut shortcut) {
        this.serverRegionShortcut = shortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return this.serverRegionShortcut;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    protected Class<V> getValueConstraint() {
        return this.valueConstraint;
    }
}

