/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.snapshot.SnapshotServiceFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class SnapshotServiceParser
extends AbstractSingleBeanDefinitionParser {
    SnapshotServiceParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return SnapshotServiceFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        ParsingUtils.setCacheReference(element, builder);
        ParsingUtils.setRegionReference(element, builder);
        ParsingUtils.setPropertyValue(element, builder, "suppress-import-on-init");
        builder.addPropertyValue("exports", this.parseExports(element, parserContext));
        builder.addPropertyValue("imports", this.parseImports(element, parserContext));
    }

    private ManagedList<BeanDefinition> parseExports(Element element, ParserContext parserContext) {
        return this.parseSnapshots(element, parserContext, "snapshot-export");
    }

    private ManagedList<BeanDefinition> parseImports(Element element, ParserContext parserContext) {
        return this.parseSnapshots(element, parserContext, "snapshot-import");
    }

    private ManagedList<BeanDefinition> parseSnapshots(Element element, ParserContext parserContext, String childTagName) {
        ManagedList snapshotBeans = new ManagedList();
        for (Element childElement : DomUtils.getChildElementsByTagName((Element)element, (String)childTagName)) {
            snapshotBeans.add((Object)this.parseSnapshotMetadata(childElement, parserContext));
        }
        return snapshotBeans;
    }

    private BeanDefinition parseSnapshotMetadata(Element snapshotMetadataElement, ParserContext parserContext) {
        BeanDefinitionBuilder snapshotMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(SnapshotServiceFactoryBean.SnapshotMetadata.class);
        snapshotMetadataBuilder.addConstructorArgValue((Object)snapshotMetadataElement.getAttribute("location"));
        if (this.isSnapshotFilterSpecified(snapshotMetadataElement)) {
            snapshotMetadataBuilder.addConstructorArgValue(ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, snapshotMetadataElement, snapshotMetadataBuilder, "filter-ref", true));
        }
        snapshotMetadataBuilder.addConstructorArgValue((Object)snapshotMetadataElement.getAttribute("format"));
        return snapshotMetadataBuilder.getBeanDefinition();
    }

    private boolean isSnapshotFilterSpecified(Element snapshotMetadataElement) {
        return snapshotMetadataElement.hasAttribute("filter-ref") || snapshotMetadataElement.hasChildNodes();
    }
}

