/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;

public abstract class AbstractFactoryBeanSupport<T>
implements FactoryBean<T>,
BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware {
    protected static final boolean DEFAULT_SINGLETON = true;
    private ClassLoader beanClassLoader;
    private BeanFactory beanFactory;
    private final Log log = this.newLog();
    private String beanName;

    protected Log newLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    protected Log getLog() {
        return this.log;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void logDebug(String message, Object ... args) {
        this.logDebug(StringFormatSupplier.of(message, args));
    }

    protected void logDebug(Supplier<String> message) {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)message.get());
        }
    }

    protected void logInfo(String message, Object ... args) {
        this.logInfo(StringFormatSupplier.of(message, args));
    }

    protected void logInfo(Supplier<String> message) {
        Log log = this.getLog();
        if (log.isInfoEnabled()) {
            log.info((Object)message.get());
        }
    }

    protected void logWarning(String message, Object ... args) {
        this.logWarning(StringFormatSupplier.of(message, args));
    }

    protected void logWarning(Supplier<String> message) {
        Log log = this.getLog();
        if (log.isWarnEnabled()) {
            log.warn((Object)message.get());
        }
    }

    protected void logError(String message, Object ... args) {
        this.logError(StringFormatSupplier.of(message, args));
    }

    protected void logError(Supplier<String> message) {
        Log log = this.getLog();
        if (log.isErrorEnabled()) {
            log.error((Object)message.get());
        }
    }

    protected static class StringFormatSupplier
    implements Supplier<String> {
        private final Object[] args;
        private final String message;

        protected static StringFormatSupplier of(String message, Object ... args) {
            return new StringFormatSupplier(message, ArrayUtils.nullSafeArray(args, Object.class));
        }

        private StringFormatSupplier(String message, Object ... args) {
            Assert.hasText((String)message, (String)"Message is required");
            this.message = message;
            this.args = args;
        }

        @Override
        public String get() {
            return String.format(this.message, this.args);
        }
    }

    protected static interface Supplier<T> {
        public T get();
    }
}

