/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.common.annotation.configurers;

import org.springframework.data.hadoop.config.common.annotation.AnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.data.hadoop.config.common.annotation.configurers.SecurityConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.SecurityConfigurerAware;
import org.springframework.data.hadoop.security.HadoopSecurity;
import org.springframework.data.hadoop.security.SecurityAuthMethod;
import org.springframework.util.StringUtils;

public class DefaultSecurityConfigurer<O, I, B extends AnnotationBuilder<O>>
extends AnnotationConfigurerAdapter<O, I, B>
implements SecurityConfigurer<I> {
    private HadoopSecurity hadoopSecurity = new HadoopSecurity();

    @Override
    public SecurityConfigurer<I> authMethod(String authMethod) {
        SecurityAuthMethod method;
        if (StringUtils.hasText((String)authMethod) && (method = SecurityAuthMethod.valueOf((String)authMethod.toUpperCase())) != null) {
            this.hadoopSecurity.setSecurityAuthMethod(method);
        }
        return this;
    }

    @Override
    public SecurityConfigurer<I> authMethod(SecurityAuthMethod authMethod) {
        if (authMethod != null) {
            this.hadoopSecurity.setSecurityAuthMethod(authMethod);
        }
        return this;
    }

    @Override
    public SecurityConfigurer<I> userPrincipal(String principal) {
        if (StringUtils.hasText((String)principal)) {
            this.hadoopSecurity.setUserPrincipal(principal);
        }
        return this;
    }

    @Override
    public SecurityConfigurer<I> userKeytab(String keytab) {
        if (StringUtils.hasText((String)keytab)) {
            this.hadoopSecurity.setUserKeytab(keytab);
        }
        return this;
    }

    @Override
    public void configure(B builder) throws Exception {
        if (!this.configureSecurity(builder, this.hadoopSecurity) && builder instanceof SecurityConfigurerAware) {
            ((SecurityConfigurerAware)builder).configureSecurity(this.hadoopSecurity);
        }
    }

    @Override
    public SecurityConfigurer<I> namenodePrincipal(String principal) {
        if (StringUtils.hasText((String)principal)) {
            this.hadoopSecurity.setNamenodePrincipal(principal);
        }
        return this;
    }

    @Override
    public SecurityConfigurer<I> rmManagerPrincipal(String principal) {
        if (StringUtils.hasText((String)principal)) {
            this.hadoopSecurity.setRmManagerPrincipal(principal);
        }
        return this;
    }

    public HadoopSecurity getSecurity() {
        return this.hadoopSecurity;
    }

    protected boolean configureSecurity(B builder, HadoopSecurity security) {
        return false;
    }
}

