/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.util.Arrays;
import java.util.List;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;

public class HashRangeMethodExecutor
implements MethodExecutor {
    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        if (arguments[1] instanceof List) {
            try {
                Object[] ranges = ((List)arguments[1]).toArray(new Object[0]);
                int searchIndex = Arrays.binarySearch(ranges, arguments[0]);
                return new TypedValue((Object)(ranges[Math.min(searchIndex < 0 ? -searchIndex - 1 : searchIndex, ranges.length - 1)] + "_range"));
            }
            catch (Exception e) {
                throw new AccessException("Error finding range", e);
            }
        }
        throw new AccessException("Argument " + arguments[1] + " not a List");
    }
}

