/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.output.AbstractPartitionDataStoreWriter;
import org.springframework.data.hadoop.store.output.TextFileWriter;
import org.springframework.data.hadoop.store.partition.PartitionStrategy;

public class PartitionTextFileWriter<K>
extends AbstractPartitionDataStoreWriter<String, K> {
    public PartitionTextFileWriter(Configuration configuration, Path basePath, CodecInfo codec, PartitionStrategy<String, K> partitionStrategy) {
        super(configuration, basePath, codec, partitionStrategy);
    }

    @Override
    protected DataStoreWriter<String> createWriter(Configuration configuration, Path path, CodecInfo codec) {
        TextFileWriter writer = new TextFileWriter(this.getConfiguration(), path != null ? new Path(this.getBasePath(), path) : this.getBasePath(), codec);
        if (this.getBeanFactory() != null) {
            writer.setBeanFactory(this.getBeanFactory());
        }
        writer.setPhase(this.getPhase());
        if (this.getTaskExecutor() != null) {
            writer.setTaskExecutor(this.getTaskExecutor());
        }
        if (this.getTaskScheduler() != null) {
            writer.setTaskScheduler(this.getTaskScheduler());
        }
        writer.setAutoStartup(this.isAutoStartup());
        if (this.getStoreEventPublisher() != null) {
            writer.setStoreEventPublisher(this.getStoreEventPublisher());
        }
        if (this.getFileNamingStrategyFactory() != null) {
            writer.setFileNamingStrategy(this.getFileNamingStrategyFactory().createInstance());
        }
        if (this.getRolloverStrategyFactory() != null) {
            writer.setRolloverStrategy(this.getRolloverStrategyFactory().createInstance());
        }
        writer.setIdleTimeout(this.getIdleTimeout());
        writer.setOverwrite(this.isOverwrite());
        writer.setInWritingPrefix(this.getInWritingPrefix());
        writer.setInWritingSuffix(this.getInWritingSuffix());
        writer.setMaxOpenAttempts(this.getMaxOpenAttempts());
        writer.afterPropertiesSet();
        writer.start();
        return writer;
    }
}

