/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.partition;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.expression.MapExpressionMethods;
import org.springframework.data.hadoop.store.partition.AbstractPartitionStrategy;
import org.springframework.data.hadoop.store.partition.DefaultPartitionKey;
import org.springframework.data.hadoop.store.partition.PartitionKeyResolver;
import org.springframework.data.hadoop.store.partition.PartitionResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class DefaultPartitionStrategy<T>
extends AbstractPartitionStrategy<T, Map<String, Object>> {
    private static final Log log = LogFactory.getLog(DefaultPartitionStrategy.class);

    public DefaultPartitionStrategy(Expression expression) {
        this(expression, null);
    }

    public DefaultPartitionStrategy(Expression expression, EvaluationContext evaluationContext) {
        super(new MapPartitionResolver(expression, evaluationContext), new MapPartitionKeyResolver());
    }

    public DefaultPartitionStrategy(String expression) {
        this(expression, null);
    }

    public DefaultPartitionStrategy(String expression, EvaluationContext evaluationContext) {
        super(new MapPartitionResolver(expression, evaluationContext), new MapPartitionKeyResolver());
    }

    private static class MapPartitionKeyResolver<T>
    implements PartitionKeyResolver<T, Map<String, Object>> {
        private MapPartitionKeyResolver() {
        }

        @Override
        public Map<String, Object> resolvePartitionKey(T entity) {
            return new DefaultPartitionKey(entity);
        }
    }

    private static class MapPartitionResolver
    implements PartitionResolver<Map<String, Object>> {
        private final Expression expression;
        private final MapExpressionMethods methods;

        public MapPartitionResolver(String expression, EvaluationContext evaluationContext) {
            SpelExpressionParser parser = new SpelExpressionParser();
            this.expression = parser.parseExpression(expression);
            this.methods = new MapExpressionMethods(evaluationContext);
            log.info((Object)("Using expression=[" + this.expression.getExpressionString() + "]"));
        }

        public MapPartitionResolver(Expression expression, EvaluationContext evaluationContext) {
            this.expression = expression;
            this.methods = new MapExpressionMethods(evaluationContext);
            log.info((Object)("Using expression=[" + this.expression.getExpressionString() + "]"));
        }

        @Override
        public Path resolvePath(Map<String, Object> partitionKey) {
            return new Path(this.methods.getValue(this.expression, partitionKey, String.class));
        }
    }
}

