/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.split;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.store.split.GenericSplit;
import org.springframework.data.hadoop.store.split.Split;
import org.springframework.data.hadoop.store.split.Splitter;

public abstract class AbstractSplitter
implements Splitter {
    private Configuration configuration;

    public AbstractSplitter() {
    }

    public AbstractSplitter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public abstract List<Split> getSplits(Path var1) throws IOException;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Autowired(required=false)
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected long computeSplitSize(long blockSize, long minSize, long maxSize) {
        return Math.max(minSize, Math.min(maxSize, blockSize));
    }

    protected int getBlockIndex(BlockLocation[] blocks, long offset) {
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i].getOffset() > offset || offset >= blocks[i].getOffset() + blocks[i].getLength()) continue;
            return i;
        }
        BlockLocation block = blocks[blocks.length - 1];
        long length = block.getOffset() + block.getLength() - 1L;
        throw new IllegalArgumentException("Offset " + offset + " is outside of file with length=" + length);
    }

    protected Split buildSplit(long start, long length, String[] hosts) {
        return new GenericSplit(start, length, hosts);
    }
}

