/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.Assert;

public abstract class PollingTaskSupport<T> {
    private volatile Trigger trigger;
    private volatile Runnable poller;
    private volatile ScheduledFuture<?> runningTask;
    private TaskScheduler taskScheduler;
    private TaskExecutor taskExecutor;

    public PollingTaskSupport(TaskScheduler taskScheduler, TaskExecutor taskExecutor) {
        this(taskScheduler, taskExecutor, TimeUnit.SECONDS, 5L);
    }

    public PollingTaskSupport(TaskScheduler taskScheduler, TaskExecutor taskExecutor, TimeUnit unit, long duration) {
        this.taskScheduler = taskScheduler;
        this.taskExecutor = taskExecutor;
        this.trigger = new PeriodicTrigger(unit.toMillis(duration));
    }

    public PollingTaskSupport(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
        this.taskScheduler = taskScheduler;
        this.taskExecutor = taskExecutor;
        this.trigger = trigger;
    }

    public void init() {
        Assert.notNull((Object)this.taskScheduler, (String)"Task scheduler must be set");
        Assert.notNull((Object)this.taskExecutor, (String)"Task executor must be set");
        this.poller = this.createPoller();
    }

    public void start() {
        this.runningTask = this.taskScheduler.schedule(this.poller, this.trigger);
    }

    public void stop() {
        if (this.runningTask != null) {
            this.runningTask.cancel(true);
        }
        this.runningTask = null;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    protected abstract T doPoll();

    protected void onPollResult(T result) {
    }

    private Runnable createPoller() {
        Callable pollingTask = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return PollingTaskSupport.this.doPoll();
            }
        };
        return new Poller(pollingTask);
    }

    private class Poller
    implements Runnable {
        private final Callable<T> pollingTask;

        public Poller(Callable<T> pollingTask) {
            this.pollingTask = pollingTask;
        }

        @Override
        public void run() {
            PollingTaskSupport.this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PollingTaskSupport.this.onPollResult(Poller.this.pollingTask.call());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error executing polling task", e);
                    }
                }
            });
        }
    }
}

