/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.hadoop.store.expression.MapPartitionKeyPropertyAccessor;
import org.springframework.data.hadoop.store.expression.PartitionKeyMethodResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class MapExpressionMethods {
    private final StandardEvaluationContext context;

    public MapExpressionMethods() {
        this(null);
    }

    public MapExpressionMethods(EvaluationContext evaluationContext) {
        if (evaluationContext instanceof StandardEvaluationContext) {
            this.context = (StandardEvaluationContext)evaluationContext;
        } else {
            this.context = new StandardEvaluationContext();
            this.context.addMethodResolver((MethodResolver)new PartitionKeyMethodResolver());
            this.context.addPropertyAccessor((PropertyAccessor)new MapPartitionKeyPropertyAccessor());
        }
    }

    public MapExpressionMethods(StandardEvaluationContext evaluationContext, boolean autoCustomize, boolean replaceMethodResolver) {
        Assert.notNull((Object)evaluationContext, (String)"Evaluation context cannot be null");
        if (autoCustomize) {
            PartitionKeyMethodResolver methodResolver = new PartitionKeyMethodResolver();
            if (replaceMethodResolver) {
                ArrayList<PartitionKeyMethodResolver> methodResolvers = new ArrayList<PartitionKeyMethodResolver>();
                methodResolvers.add(methodResolver);
                evaluationContext.setMethodResolvers(methodResolvers);
            } else {
                evaluationContext.addMethodResolver((MethodResolver)methodResolver);
            }
        }
        if (autoCustomize) {
            evaluationContext.addPropertyAccessor((PropertyAccessor)new MapPartitionKeyPropertyAccessor());
        }
        this.context = evaluationContext;
    }

    public <T> T getValue(Expression expression, Map<String, Object> map, Class<T> desiredResultType) throws EvaluationException {
        Assert.notNull((Object)expression, (String)"Expression cannot be null");
        return (T)expression.getValue((EvaluationContext)this.context, map, desiredResultType);
    }
}

