/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.batch;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HdfsItemReader<T>
extends FlatFileItemReader<T> {
    private Resource resource;
    private HdfsResourceLoader loader;
    private String location;

    public HdfsItemReader(Configuration configuration) {
        this(new HdfsResourceLoader(configuration));
    }

    public HdfsItemReader(FileSystem fs) {
        this(new HdfsResourceLoader(fs));
    }

    public HdfsItemReader(HdfsResourceLoader hdfsLoader) {
        Assert.notNull((Object)hdfsLoader, (String)"a valid resource loader is required");
        this.loader = hdfsLoader;
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
    }

    protected void doOpen() throws Exception {
        if (this.resource == null) {
            Assert.hasText((String)this.location, (String)"either a resource or a location need to be specified");
            this.resource = this.loader.getResource(this.location);
            Assert.isTrue((this.resource.exists() && this.resource.isReadable() ? 1 : 0) != 0, (String)("non-existing or non-readable resource " + this.resource));
        }
        this.setResource(this.resource);
        super.doOpen();
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

