/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading.tap.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

class DelegatingResource
extends AbstractResource {
    private final Resource[] resources;
    private final boolean exists;
    private final boolean readable;
    private final boolean open;
    private final long lastModified;
    private final long contentLength;
    private final String toString;

    DelegatingResource(Resource[] resources) {
        Assert.notEmpty((Object[])resources, (String)"at least one resource needs to be specified");
        this.resources = resources;
        boolean e = false;
        boolean r = false;
        boolean o = false;
        long lm = -1L;
        long cl = 0L;
        for (Resource resource : resources) {
            e |= resource.exists();
            r |= resource.isReadable();
            o |= resource.isOpen();
            try {
                long llm = resource.lastModified();
                if (llm > lm) {
                    lm = llm;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                cl += resource.contentLength();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.exists = e;
        this.readable = r;
        this.open = o;
        this.lastModified = lm;
        this.contentLength = cl;
        this.toString = "DelegatingResource for " + Arrays.toString(resources);
    }

    public InputStream getInputStream() throws IOException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>(this.resources.length);
        for (Resource res : this.resources) {
            streams.add(res.getInputStream());
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isOpen() {
        return this.open;
    }

    public long contentLength() throws IOException {
        return this.contentLength;
    }

    public long lastModified() throws IOException {
        return this.lastModified;
    }

    public String getDescription() {
        return this.toString;
    }
}

