/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading.tap.local;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.integration.Message;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.message.GenericMessage;

class MessageHandlerOutputStream
extends OutputStream {
    private final MessageHandler handler;
    private List<Byte> buffer = new ArrayList<Byte>();

    MessageHandlerOutputStream(MessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.add((byte)b);
    }

    void endMessage() {
        if (!this.buffer.isEmpty()) {
            byte[] raw = new byte[this.buffer.size()];
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = this.buffer.get(i);
            }
            this.buffer.clear();
            this.handler.handleMessage((Message)new GenericMessage((Object)raw));
        }
    }

    @Override
    public void flush() throws IOException {
        this.endMessage();
    }

    @Override
    public void close() throws IOException {
        this.buffer.clear();
    }

    public String toString() {
        return "OutputStream for " + this.handler;
    }
}

