/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading.tap.local;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.SinkTap;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntrySchemeCollector;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.springframework.data.hadoop.cascading.tap.local.MessageHandlerOutputStream;
import org.springframework.integration.core.MessageHandler;

public class MessageHandlerTap
extends SinkTap<Properties, OutputStream> {
    private final MessageHandlerOutputStream handler;
    private long modifiedTime = -1L;

    public MessageHandlerTap(Scheme<Properties, ?, OutputStream, ?, ?> scheme, MessageHandler handler) {
        super(scheme);
        this.handler = new MessageHandlerOutputStream(handler);
    }

    public String getIdentifier() {
        return this.handler.toString();
    }

    public TupleEntryCollector openForWrite(FlowProcess<Properties> flowProcess, OutputStream output) throws IOException {
        if (output == null) {
            return new TupleEntrySchemeCollector<Properties, OutputStream>(flowProcess, this.getScheme(), (OutputStream)this.handler, this.getIdentifier()){

                protected void collect(TupleEntry tupleEntry) throws IOException {
                    super.collect(tupleEntry);
                    MessageHandlerTap.this.handler.endMessage();
                }
            };
        }
        return new TupleEntrySchemeCollector(flowProcess, this.getScheme(), (Object)output, this.getIdentifier());
    }

    public boolean createResource(Properties conf) throws IOException {
        return true;
    }

    public boolean deleteResource(Properties conf) throws IOException {
        return false;
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return true;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return this.modifiedTime;
    }
}

