/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading.tap.local;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.SourceTap;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.cascading.tap.local.DelegatingResource;
import org.springframework.util.Assert;

public class ResourceTap
extends SourceTap<Properties, Resource> {
    private final Resource resource;

    public ResourceTap(Scheme<Properties, Resource, ?, ?, ?> scheme, Resource resource) {
        this(scheme, new Resource[]{resource});
    }

    public ResourceTap(Scheme<Properties, Resource, ?, ?, ?> scheme, Resource[] resources) {
        super(scheme);
        Assert.notEmpty((Object[])resources, (String)"at least one resource is required");
        this.resource = resources.length == 1 ? resources[0] : new DelegatingResource(resources);
    }

    public String getIdentifier() {
        return this.resource.toString();
    }

    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, Resource input) throws IOException {
        InputStream in = input != null ? input.getInputStream() : this.resource.getInputStream();
        return new TupleEntrySchemeIterator(flowProcess, this.getScheme(), (Object)in, this.getIdentifier());
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return this.resource.exists();
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return this.resource.lastModified();
    }
}

