/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import java.util.Collection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.AbstractImprovedSimpleBeanDefinitionParser;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.data.hadoop.config.PigServerParser;
import org.springframework.data.hadoop.pig.PigRunner;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Element;

class PigRunnerParser
extends AbstractImprovedSimpleBeanDefinitionParser {
    PigRunnerParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return PigRunner.class;
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"location".equals(attributeName) && !"pre-action".equals(attributeName) && !"post-action".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        NamespaceUtils.setCSVReferenceProperty(element, builder, "pre-action", "preAction");
        NamespaceUtils.setCSVReferenceProperty(element, builder, "post-action", "postAction");
        Collection<BeanDefinition> scripts = PigServerParser.parseScripts(parserContext, element);
        if (!CollectionUtils.isEmpty(scripts)) {
            builder.addPropertyValue("scripts", scripts);
        }
    }
}

