/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.configuration;

import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public class ConfigurationFactoryBean
implements BeanClassLoaderAware,
InitializingBean,
FactoryBean<Configuration> {
    private static final Log log = LogFactory.getLog(ConfigurationFactoryBean.class);
    private Configuration internalConfig;
    private Configuration configuration;
    private boolean loadDefaults = true;
    private Set<Resource> resources;
    private Properties properties;
    private ClassLoader beanClassLoader = this.getClass().getClassLoader();
    private boolean initialize = true;
    private boolean registerJvmUrl = false;

    public void afterPropertiesSet() throws Exception {
        this.internalConfig = this.createConfiguration(this.configuration);
        this.internalConfig.setClassLoader(this.beanClassLoader);
        if (this.resources != null) {
            for (Resource resource : this.resources) {
                this.internalConfig.addResource(resource.getURL());
            }
        }
        ConfigurationUtils.addProperties(this.internalConfig, this.properties);
        if (this.initialize) {
            this.internalConfig.size();
        }
        this.postProcessConfiguration(this.internalConfig);
        if (this.registerJvmUrl) {
            try {
                UserGroupInformation.setConfiguration((Configuration)this.internalConfig);
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory(this.getObject()));
                log.info((Object)"Registered HDFS URL stream handler");
            }
            catch (Error err) {
                log.warn((Object)"Cannot register Hadoop URL stream handler - one is already registered");
            }
        }
    }

    protected Configuration createConfiguration(Configuration existing) {
        return existing != null ? new Configuration(existing) : new Configuration(this.loadDefaults);
    }

    protected void postProcessConfiguration(Configuration configuration) {
    }

    public Configuration getObject() {
        return this.internalConfig;
    }

    public Class<?> getObjectType() {
        return this.internalConfig != null ? this.internalConfig.getClass() : Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setLoadDefaults(boolean loadDefaults) {
        this.loadDefaults = loadDefaults;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void setRegisterUrlHandler(boolean register) {
        this.registerJvmUrl = register;
    }
}

