/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.mapreduce.JobUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

abstract class JobExecutor
implements InitializingBean,
BeanFactoryAware {
    private Collection<Job> jobs;
    private Iterable<String> jobNames;
    private boolean waitForJobs = true;
    private BeanFactory beanFactory;
    private boolean verbose = true;

    JobExecutor() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((boolean)(this.jobs != null | this.jobNames != null), (String)"A Hadoop job or its name is required");
        if (this.jobNames != null) {
            for (String jobName : this.jobNames) {
                if (!StringUtils.hasText((String)jobName)) continue;
                Assert.notNull((Object)this.beanFactory, (String)"a bean factory is required if the job is specified by name");
                Assert.isTrue((boolean)this.beanFactory.containsBean(jobName), (String)("beanFactory does not contain any bean named [" + this.jobNames + "]"));
            }
        }
    }

    protected void executeJobs() throws Exception {
        Boolean succesful = Boolean.TRUE;
        Collection<Job> jbs = this.findJobs();
        if (CollectionUtils.isEmpty(jbs)) {
            return;
        }
        for (Job job : jbs) {
            if (!this.waitForJobs) {
                job.submit();
                continue;
            }
            if ((succesful = Boolean.valueOf(succesful & job.waitForCompletion(this.verbose))).booleanValue()) continue;
            RunningJob rj = JobUtils.getRunningJob(job);
            throw new IllegalStateException("Job [" + job.getJobName() + "] failed - " + (rj != null ? rj.getFailureInfo() : "N/A"));
        }
    }

    private Collection<Job> findJobs() {
        if (this.jobs != null) {
            return this.jobs;
        }
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (String name : this.jobNames) {
            jobs.add((Job)this.beanFactory.getBean(name, Job.class));
        }
        return jobs;
    }

    public void setJob(Job job) {
        this.jobs = Collections.singleton(job);
    }

    public void setJobs(Collection<Job> jobs) {
        this.jobs = jobs;
    }

    public void setJobNames(String ... jobName) {
        this.jobNames = Arrays.asList(jobName);
    }

    public void setWaitForJob(boolean waitForJob) {
        this.waitForJobs = waitForJob;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

