/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;

abstract class JobGenericOptions {
    final Log log = LogFactory.getLog(this.getClass());
    Resource[] files;
    Resource[] libJars;
    Resource[] archives;
    String user;

    JobGenericOptions() {
    }

    public void setLibs(Resource ... libJars) {
        this.libJars = libJars;
    }

    public void setFiles(Resource ... files) {
        this.files = files;
    }

    public void setArchives(Resource ... archives) {
        this.archives = archives;
    }

    void buildGenericOptions(Configuration cfg) {
        ArrayList<String> args = new ArrayList<String>();
        try {
            this.addResource(this.files, "-files", args);
            this.addResource(this.libJars, "-libjars", args);
            this.addResource(this.archives, "-archives", args);
            new GenericOptionsParser(cfg, args.toArray(new String[args.size()]));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void addResource(Resource[] args, String name, List<String> list) throws IOException {
        if (!ObjectUtils.isEmpty((Object[])args)) {
            int count = args.length;
            list.add(name);
            StringBuilder sb = new StringBuilder();
            for (Resource res : args) {
                sb.append(res.getURI().toString());
                if (--count <= 0) continue;
                sb.append(",");
            }
            list.add(sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Adding to generic option arg [" + name + "], resources " + sb.toString()));
            }
        }
    }

    public void setUser(String user) {
        this.user = user;
    }
}

