/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.IOUtils;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.BackendException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobCreationException;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.parser.ParserException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.data.hadoop.pig.PigScript;
import org.springframework.util.Assert;

abstract class PigUtils {
    PigUtils() {
    }

    static DataAccessException convert(PigException ex) {
        if (ex instanceof BackendException) {
            return new DataAccessResourceFailureException("Backend Pig exception", (Throwable)ex);
        }
        if (ex instanceof VisitorException || ex instanceof PlanException || ex instanceof SchemaMergeException) {
            return new InvalidDataAccessResourceUsageException("Plan failed", (Throwable)ex);
        }
        if (ex instanceof FrontendException) {
            if (ex instanceof JobCreationException) {
                return new InvalidDataAccessResourceUsageException("Map Reduce error", (Throwable)ex);
            }
            if (ex instanceof ParserException) {
                return new InvalidDataAccessResourceUsageException("Syntax error", (Throwable)ex);
            }
        }
        return new NonTransientDataAccessResourceException("Unknown Pig error", (Throwable)ex);
    }

    static DataAccessException convert(IOException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof PigException) {
            return PigUtils.convert((PigException)ex);
        }
        return new NonTransientDataAccessResourceException("Unknown Pig error", (Throwable)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ExecJob> run(PigServer pig, Iterable<PigScript> scripts) throws ExecException, IOException {
        Assert.notNull(scripts, (String)"at least one script is required");
        if (!pig.isBatchOn()) {
            pig.setBatchOn();
        }
        ArrayList<ExecJob> jobs = new ArrayList<ExecJob>();
        pig.getPigContext().connect();
        InputStream in = null;
        try {
            for (PigScript script : scripts) {
                try {
                    in = script.getResource().getInputStream();
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Cannot open script [" + script.getResource() + "]", ex);
                }
                pig.registerScript(in, script.getArguments());
                jobs.addAll(pig.executeBatch());
            }
        }
        finally {
            IOUtils.closeStream(in);
        }
        return jobs;
    }

    static List<ExecJob> runWithConversion(PigServer pig, Iterable<PigScript> scripts, boolean closePig) throws DataAccessException {
        try {
            List<ExecJob> list = PigUtils.run(pig, scripts);
            return list;
        }
        catch (ExecException ex) {
            throw PigUtils.convert((PigException)ex);
        }
        catch (IOException ex) {
            throw PigUtils.convert(ex);
        }
        finally {
            if (closePig) {
                pig.shutdown();
            }
        }
    }
}

