/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.management.UnitOfWork;
import cascading.stats.CascadingStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;

class CascadingExecutor
implements DisposableBean {
    protected boolean waitToComplete = true;
    protected UnitOfWork<? extends CascadingStats> uow;
    protected Log log = LogFactory.getLog(this.getClass());

    CascadingExecutor() {
    }

    protected CascadingStats execute() {
        if (this.waitToComplete) {
            this.uow.complete();
        } else {
            this.uow.start();
        }
        return this.uow.getStats();
    }

    public void destroy() {
        if (this.uow != null) {
            this.uow.stop();
        }
    }

    public void setUnitOfWork(UnitOfWork<? extends CascadingStats> uow) {
        this.uow = uow;
    }

    public boolean isWaitForCompletion() {
        return this.waitToComplete;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitToComplete = waitForCompletion;
    }
}

