/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.AbstractGenericOptionsParser;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.data.hadoop.mapreduce.ToolRunner;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ToolRunnerParser
extends AbstractGenericOptionsParser {
    ToolRunnerParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return ToolRunner.class;
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"pre-action".equals(attributeName) && !"post-action".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        ToolRunnerParser.parseToolDefinition(element, parserContext, builder);
        NamespaceUtils.setCSVReferenceProperty(element, builder, "pre-action", "preAction");
        NamespaceUtils.setCSVReferenceProperty(element, builder, "post-action", "postAction");
    }

    static void parseToolDefinition(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List list = DomUtils.getChildElements((Element)element);
        ManagedList args = new ManagedList();
        for (Element child : list) {
            String localName = child.getLocalName();
            if ("arg".equals(localName)) {
                args.add((Object)child.getAttribute("value").trim());
            }
            if (!"tool".equals(localName)) continue;
            if (element.hasAttribute("tool-class") || element.hasAttribute("tool-ref")) {
                parserContext.getReaderContext().error("Cannot define nested and top-level tool-class/tool-ref attributes - use only one", (Object)element);
            }
            builder.addPropertyValue("tool", parserContext.getDelegate().parsePropertySubElement((Element)DomUtils.getChildElements((Element)child).get(0), (BeanDefinition)builder.getRawBeanDefinition()));
        }
        builder.addPropertyValue("arguments", (Object)args);
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

