/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.scripting;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.hadoop.fs.DistCp;
import org.springframework.data.hadoop.fs.FsShell;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.data.hadoop.fs.SimplerFileSystem;
import org.springframework.data.hadoop.scripting.Jsr223ScriptRunner;
import org.springframework.util.Assert;

public class HdfsScriptRunner
extends Jsr223ScriptRunner
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(HdfsScriptRunner.class);
    private ApplicationContext ctx;
    private Configuration configuration;

    @Override
    protected void postProcess(Map<String, Object> args) {
        String name = "cfg";
        if (!this.hasBinding(args, name, Configuration.class)) {
            this.putIfAbsent(args, name, this.detectCfg(name));
        }
        Configuration cfg = (Configuration)args.get(name);
        name = "hdfsRL";
        if (!this.hasBinding(args, name, HdfsResourceLoader.class)) {
            this.putIfAbsent(args, name, this.detectHdfsRL(name, cfg));
        }
        if (!this.hasBinding(args, name = "fs", FileSystem.class)) {
            this.putIfAbsent(args, name, this.detectFS(name, cfg));
        }
        FileSystem fs = (FileSystem)args.get(name);
        name = "distcp";
        if (!this.hasBinding(args, name, DistCp.class)) {
            if (cfg == null) {
                log.warn((Object)String.format("No Hadoop Configuration detected; not binding DistCp as variable '%s' to script", name));
            } else {
                this.putIfAbsent(args, name, new DistCp(cfg));
            }
        }
        if (!this.hasBinding(args, name = "fsh", FsShell.class)) {
            if (cfg == null) {
                log.warn((Object)String.format("No Hadoop Configuration detected; not binding FsShell as variable '%s' to script", name));
            } else {
                this.putIfAbsent(args, name, new FsShell(cfg, fs));
            }
        }
        this.putIfAbsent(args, "cl", this.ctx.getClassLoader());
        this.putIfAbsent(args, "ctxRL", this.ctx);
        this.putIfAbsent(args, "ctx", this.ctx);
    }

    private boolean hasBinding(Map<String, Object> args, String key, Class<?> type) {
        if (args.containsKey(key)) {
            Assert.isInstanceOf(type, (Object)args.get(key), (String)("Invalid property '" + key + "' "));
        }
        return false;
    }

    private Configuration detectCfg(String variableName) {
        if (this.configuration != null) {
            return this.configuration;
        }
        String defaultName = "hadoopConfiguration";
        Class<Configuration> defaultType = Configuration.class;
        if (this.ctx.containsBean(defaultName)) {
            return (Configuration)this.ctx.getBean(defaultName, defaultType);
        }
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.ctx, defaultType);
        if (names != null && names.length == 1) {
            return (Configuration)this.ctx.getBean(names[0], defaultType);
        }
        log.warn((Object)String.format("No Hadoop Configuration detected; not binding Configuration as variable '%s' to script", variableName));
        return null;
    }

    private HdfsResourceLoader detectHdfsRL(String variableName, Configuration cfg) {
        String defaultName = "hadoopResourceLoader";
        Class<HdfsResourceLoader> defaultType = HdfsResourceLoader.class;
        if (this.ctx.containsBean(defaultName)) {
            return (HdfsResourceLoader)this.ctx.getBean(defaultName, defaultType);
        }
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.ctx, defaultType);
        if (names != null && names.length == 1) {
            return (HdfsResourceLoader)this.ctx.getBean(names[0], defaultType);
        }
        if (cfg == null) {
            log.warn((Object)String.format("No Hadoop Configuration or ResourceLoader detected; not binding variable '%s' to script", variableName));
            return null;
        }
        return new HdfsResourceLoader(cfg);
    }

    private Object detectFS(String variableName, Configuration detectedCfg) {
        String defaultName = "hadoopFs";
        Class<FileSystem> defaultType = FileSystem.class;
        if (this.ctx.containsBean(defaultName)) {
            FileSystem fs = (FileSystem)this.ctx.getBean(defaultName, defaultType);
            return fs instanceof SimplerFileSystem ? fs : new SimplerFileSystem(fs);
        }
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.ctx, defaultType);
        if (names != null && names.length == 1) {
            return this.ctx.getBean(names[0], defaultType);
        }
        if (detectedCfg == null) {
            log.warn((Object)String.format("No Hadoop Configuration or FileSystem detected; not binding variable '%s' to script", variableName));
            return null;
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)detectedCfg);
            return fs instanceof SimplerFileSystem ? fs : new SimplerFileSystem(fs);
        }
        catch (IOException ex) {
            log.warn((Object)String.format("Cannot create HDFS file system'; not binding variable '%s' to script", defaultName, defaultType, variableName), (Throwable)ex);
            return null;
        }
    }

    private void putIfAbsent(Map<String, Object> arguments, String key, Object value) {
        if (value != null && !arguments.containsKey(key)) {
            arguments.put(key, value);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.ctx, (String)"an ApplicationContext is required");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

