/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.stats.CascadingStats;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.cascading.CascadingExecutor;

public class CascadingRunner
extends CascadingExecutor
implements InitializingBean,
Callable<CascadingStats> {
    private boolean runAtStartup = false;
    private Iterable<Callable<?>> preActions;
    private Iterable<Callable<?>> postActions;

    public void afterPropertiesSet() throws Exception {
        if (this.runAtStartup) {
            this.call();
        }
    }

    @Override
    public CascadingStats call() throws Exception {
        this.invoke(this.preActions);
        CascadingStats stats = this.execute();
        this.invoke(this.postActions);
        return stats;
    }

    public void setRunAtStartup(boolean runAtStartup) {
        this.runAtStartup = runAtStartup;
    }

    public void setPreAction(Collection<Callable<?>> actions) {
        this.preActions = actions;
    }

    public void setPostAction(Collection<Callable<?>> actions) {
        this.postActions = actions;
    }

    private void invoke(Iterable<Callable<?>> actions) throws Exception {
        if (actions != null) {
            for (Callable<?> action : actions) {
                action.call();
            }
        }
    }
}

