/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import java.util.Collection;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.AbstractImprovedSimpleBeanDefinitionParser;
import org.springframework.data.hadoop.config.HiveTaskletParser;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.data.hadoop.hive.HiveRunner;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Element;

class HiveRunnerParser
extends AbstractImprovedSimpleBeanDefinitionParser {
    HiveRunnerParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return HiveRunner.class;
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"pre-action".equals(attributeName) && !"post-action".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        NamespaceUtils.setCSVReferenceProperty(element, builder, "pre-action", "preAction");
        NamespaceUtils.setCSVReferenceProperty(element, builder, "post-action", "postAction");
        Collection<Object> scripts = HiveTaskletParser.parseScripts(parserContext, element);
        if (!CollectionUtils.isEmpty(scripts)) {
            builder.addPropertyValue("scripts", scripts);
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

