/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.support.ManagedProperties;

class LinkedProperties
extends ManagedProperties {
    private final LinkedHashSet<Object> keys = new LinkedHashSet();

    LinkedProperties() {
    }

    LinkedProperties(String text) {
        try {
            this.load(new ByteArrayInputStream(text.getBytes("ISO-8859-1")));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to parse [" + text + "] into Properties", ex);
        }
    }

    public Enumeration<Object> keys() {
        return Collections.enumeration(this.keys);
    }

    public Object put(Object key, Object value) {
        this.keys.add(key);
        return super.put(key, value);
    }

    public Set<String> stringPropertyNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object e : this.keys) {
            if (!(e instanceof String) || !(this.get(e) instanceof String)) continue;
            set.add((String)e);
        }
        return set;
    }

    public Set<Object> keySet() {
        return this.keys;
    }

    public Object merge(Object parent) {
        if (!this.isMergeEnabled()) {
            throw new IllegalStateException("Not allowed to merge when the 'mergeEnabled' property is set to 'false'");
        }
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof Properties)) {
            throw new IllegalArgumentException("Cannot merge with object of type [" + parent.getClass() + "]");
        }
        LinkedProperties merged = new LinkedProperties();
        ((Properties)((Object)merged)).putAll((Map<?, ?>)((Properties)parent));
        ((Properties)((Object)merged)).putAll((Map<?, ?>)((Object)this));
        return merged;
    }
}

