/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.data.hadoop.util.VersionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DistCp {
    private final Configuration configuration;
    private String user;

    public DistCp(Configuration configuration) {
        this(configuration, null);
    }

    public DistCp(Configuration configuration, String user) {
        Assert.notNull((Object)configuration, (String)"configuration required");
        this.configuration = ConfigurationUtils.createFrom(configuration, null);
        this.configuration.setBoolean("mapred.used.genericoptionsparser", true);
        this.configuration.setBoolean("mapreduce.client.genericoptionsparser.used", true);
        this.user = user;
    }

    public void copy(EnumSet<Preserve> preserve, Boolean ignoreFailures, Boolean overwrite, Boolean update, Boolean delete, String ... uris) {
        this.copy(preserve, ignoreFailures, Boolean.FALSE, null, null, overwrite, update, delete, null, null, null, uris);
    }

    public void copy(EnumSet<Preserve> preserve, Boolean ignoreFailures, Boolean skipCrc, String logDir, Integer mappers, Boolean overwrite, Boolean update, Boolean delete, Long fileLimit, Long sizeLimit, String fileList, String ... uris) {
        Boolean r = preserve != null && preserve.contains((Object)Preserve.REPLICATION);
        Boolean b = preserve != null && preserve.contains((Object)Preserve.BLOCKSIZE);
        Boolean u = preserve != null && preserve.contains((Object)Preserve.USER);
        Boolean g = preserve != null && preserve.contains((Object)Preserve.GROUP);
        Boolean p = preserve != null && preserve.contains((Object)Preserve.PERMISSION);
        this.copy(r, b, u, g, p, ignoreFailures, skipCrc, logDir, mappers, overwrite, update, delete, fileLimit, sizeLimit, fileList, uris);
    }

    public void copy(Boolean preserveReplication, Boolean preserveBlockSize, Boolean preserveUser, Boolean preserveGroup, Boolean preservePermission, Boolean ignoreFailures, Boolean skipCrc, String logDir, Integer mappers, Boolean overwrite, Boolean update, Boolean delete, Long fileLimit, Long sizeLimit, String fileList, String ... uris) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(Preserve.toString(preserveReplication, preserveBlockSize, preserveUser, preserveGroup, preservePermission));
        if (Boolean.TRUE.equals(ignoreFailures)) {
            args.add("-i");
        }
        if (Boolean.TRUE.equals(skipCrc)) {
            args.add("-skipcrccheck");
        }
        if (logDir != null) {
            args.add("-log " + logDir);
        }
        if (mappers != null) {
            args.add("-m " + mappers);
        }
        if (Boolean.TRUE.equals(overwrite)) {
            args.add("-overwrite");
        }
        if (Boolean.TRUE.equals(update)) {
            args.add("-update");
        }
        if (Boolean.TRUE.equals(delete)) {
            args.add("-delete");
        }
        if (fileLimit != null) {
            args.add("-filelimit " + fileLimit);
        }
        if (sizeLimit != null) {
            args.add("-sizelimit " + sizeLimit);
        }
        if (StringUtils.hasText((String)fileList)) {
            args.add("-f " + fileList);
        }
        CollectionUtils.mergeArrayIntoCollection((Object)uris, args);
        this.copy(args.toArray(new String[args.size()]));
    }

    public void copy(String arg1, String arg2) {
        this.copy(new String[]{arg1, arg2});
    }

    public void copy(String arg1, String arg2, String arg3) {
        this.copy(new String[]{arg1, arg2, arg3});
    }

    public void copy(String ... arguments) {
        Assert.notEmpty((Object[])arguments, (String)"invalid number of arguments");
        final ArrayList<String> parsedArguments = new ArrayList<String>();
        for (String arg : arguments) {
            parsedArguments.addAll(Arrays.asList(StringUtils.tokenizeToStringArray((String)arg, (String)" ")));
        }
        try {
            if (StringUtils.hasText((String)this.user)) {
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)this.user, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        DistCp.invokeCopy(DistCp.this.configuration, parsedArguments.toArray(new String[parsedArguments.size()]));
                        return null;
                    }
                });
            } else {
                DistCp.invokeCopy(this.configuration, parsedArguments.toArray(new String[parsedArguments.size()]));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot run distCp impersonated as '" + this.user + "'", ex);
        }
    }

    private static void invokeCopy(Configuration config, String[] parsedArgs) {
        try {
            Class<org.apache.hadoop.tools.DistCp> cl = org.apache.hadoop.tools.DistCp.class;
            Class argClass = ClassUtils.resolveClassName((String)"org.apache.hadoop.tools.DistCp$Arguments", (ClassLoader)cl.getClassLoader());
            Method m = ReflectionUtils.findMethod(cl, (String)"copy", (Class[])new Class[]{Configuration.class, argClass});
            ReflectionUtils.makeAccessible((Method)m);
            Method v = ReflectionUtils.findMethod((Class)argClass, (String)"valueOf", (Class[])new Class[]{String[].class, Configuration.class});
            ReflectionUtils.makeAccessible((Method)v);
            Object args = ReflectionUtils.invokeMethod((Method)v, null, (Object[])new Object[]{parsedArgs, config});
            ReflectionUtils.invokeMethod((Method)m, null, (Object[])new Object[]{config, args});
        }
        catch (UndeclaredThrowableException ex) {
            Throwable throwable = ex.getUndeclaredThrowable();
            if (throwable instanceof IOException) {
                IOException ioe = (IOException)throwable;
                if (!VersionUtils.isHadoop2X()) {
                    try {
                        Class<?> duplicationException = Class.forName("org.apache.hadoop.tools.DistCp.DuplicationException");
                        if (duplicationException.isAssignableFrom(ioe.getClass())) {
                            throw new IllegalStateException("Duplicated files found...", ioe);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (ioe instanceof RemoteException) {
                    throw new IllegalStateException("Cannot distCopy", ((RemoteException)ioe).unwrapRemoteException());
                }
            }
            throw ex;
        }
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static enum Preserve {
        REPLICATION,
        BLOCKSIZE,
        USER,
        GROUP,
        PERMISSION;


        static String toString(EnumSet<Preserve> preserve) {
            if (CollectionUtils.isEmpty(preserve)) {
                return "";
            }
            return Preserve.toString(preserve.contains((Object)REPLICATION), preserve.contains((Object)BLOCKSIZE), preserve.contains((Object)USER), preserve.contains((Object)GROUP), preserve.contains((Object)PERMISSION));
        }

        static String toString(Boolean preserveReplication, Boolean preserveBlockSize, Boolean preserveUser, Boolean preserveGroup, Boolean preservePermission) {
            StringBuilder sb = new StringBuilder();
            if (Boolean.TRUE.equals(preserveReplication)) {
                sb.append("r");
            }
            if (Boolean.TRUE.equals(preserveBlockSize)) {
                sb.append("b");
            }
            if (Boolean.TRUE.equals(preserveUser)) {
                sb.append("u");
            }
            if (Boolean.TRUE.equals(preserveGroup)) {
                sb.append("g");
            }
            if (Boolean.TRUE.equals(preservePermission)) {
                sb.append("p");
            }
            if (sb.length() > 0) {
                sb.insert(0, "-p");
            }
            return sb.toString();
        }
    }
}

