/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class FileSystemFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<FileSystem> {
    private FileSystem fs;
    private Configuration configuration;
    private URI uri;
    private String user;
    private boolean closeAll = false;
    private boolean close = true;

    public void afterPropertiesSet() throws Exception {
        Configuration cfg;
        Configuration configuration = cfg = this.configuration != null ? this.configuration : new Configuration(true);
        if (this.uri == null) {
            this.uri = FileSystem.getDefaultUri((Configuration)cfg);
        }
        this.fs = StringUtils.hasText((String)this.user) ? FileSystem.get((URI)this.uri, (Configuration)cfg, (String)this.user) : FileSystem.get((URI)this.uri, (Configuration)cfg);
    }

    public void destroy() throws Exception {
        if (this.fs != null && this.close) {
            this.fs.close();
        }
        this.fs = null;
        if (this.closeAll) {
            FileSystem.closeAll();
        }
    }

    public FileSystem getObject() throws Exception {
        return this.fs;
    }

    public Class<?> getObjectType() {
        return this.fs != null ? this.fs.getClass() : FileSystem.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setCloseAll(boolean closeAll) {
        this.closeAll = closeAll;
    }

    public void setClose(boolean close) {
        this.close = close;
    }
}

