/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class HbaseSynchronizationManager {
    private static final Log logger = LogFactory.getLog(HbaseSynchronizationManager.class);
    private static final ThreadLocal<Map<String, HTableInterface>> resources = new NamedThreadLocal("Bound resources");
    private static final boolean aopAvailable = ClassUtils.isPresent((String)"org.springframework.aop.scope.ScopedObject", (ClassLoader)HbaseSynchronizationManager.class.getClassLoader());

    public static boolean hasResource(Object key) {
        HTableInterface value = HbaseSynchronizationManager.doGetResource(key);
        return value != null;
    }

    public static HTableInterface getResource(Object key) {
        return HbaseSynchronizationManager.doGetResource(key);
    }

    private static HTableInterface doGetResource(Object actualKey) {
        Map<String, HTableInterface> tables = resources.get();
        if (tables == null) {
            return null;
        }
        return tables.get(actualKey);
    }

    public static void bindResource(String key, HTableInterface value) throws IllegalStateException {
        HTableInterface oldValue;
        Assert.notNull((Object)value, (String)"Value must not be null");
        Map<String, HTableInterface> map = resources.get();
        if (map == null) {
            map = new LinkedHashMap<String, HTableInterface>();
            resources.set(map);
        }
        if ((oldValue = map.put(key, value)) != null) {
            throw new IllegalStateException("Already value [" + oldValue + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Bound value [" + value + "] for key [" + key + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static HTableInterface unbindResource(String key) throws IllegalStateException {
        HTableInterface value = HbaseSynchronizationManager.doUnbindResource(key);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    public static Object unbindResourceIfPossible(Object key) {
        return HbaseSynchronizationManager.doUnbindResource(key);
    }

    private static HTableInterface doUnbindResource(Object actualKey) {
        Map<String, HTableInterface> map = resources.get();
        if (map == null) {
            return null;
        }
        HTableInterface value = map.remove(actualKey);
        if (map.isEmpty()) {
            resources.remove();
        }
        if (value != null && logger.isTraceEnabled()) {
            logger.trace((Object)("Removed value [" + value + "] for key [" + actualKey + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static Set<String> getTableNames() {
        Map<String, HTableInterface> map = resources.get();
        if (map != null && !map.isEmpty()) {
            return Collections.unmodifiableSet(map.keySet());
        }
        return Collections.emptySet();
    }
}

