/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.config.AbstractPropertiesConfiguredBeanDefinitionParser;
import org.springframework.data.hadoop.config.LinkedProperties;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.data.hadoop.pig.PigContextFactoryBean;
import org.springframework.data.hadoop.pig.PigScript;
import org.springframework.data.hadoop.pig.PigServerFactoryBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PigServerParser
extends AbstractPropertiesConfiguredBeanDefinitionParser {
    PigServerParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return PigServerFactoryBean.class;
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"paths-to-skip".equals(attributeName) && !"job-tracker".equals(attributeName) && !"configuration-ref".equals(attributeName) && !"exec-type".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected String defaultId(ParserContext context, Element element) {
        return "pigFactory";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        Collection<BeanDefinition> scripts = PigServerParser.parseScripts(parserContext, element);
        if (!CollectionUtils.isEmpty(scripts)) {
            builder.addPropertyValue("scripts", scripts);
        }
        NamespaceUtils.setCSVProperty(element, builder, "paths-to-skip", "pathsToSkip");
        BeanDefinitionBuilder contextBuilder = BeanDefinitionBuilder.genericBeanDefinition(PigContextFactoryBean.class);
        NamespaceUtils.setPropertyValue(element, contextBuilder, "job-tracker");
        NamespaceUtils.setPropertyValue(element, contextBuilder, "exec-type");
        NamespaceUtils.setPropertyReference(element, contextBuilder, "configuration-ref");
        MutablePropertyValues pv = builder.getRawBeanDefinition().getPropertyValues();
        String prop = "properties";
        if (pv.contains(prop)) {
            contextBuilder.addPropertyValue(prop, pv.getPropertyValue(prop).getValue());
            pv.removePropertyValue(prop);
        }
        builder.addPropertyValue("pigContext", (Object)contextBuilder.getBeanDefinition());
    }

    static Collection<BeanDefinition> parseScripts(ParserContext context, Element element) {
        List children = DomUtils.getChildElementsByTagName((Element)element, (String)"script");
        if (!children.isEmpty()) {
            ManagedList defs = new ManagedList(children.size());
            for (Element child : children) {
                String location = child.getAttribute("location");
                String inline = DomUtils.getTextValue((Element)child);
                boolean hasScriptInlined = StringUtils.hasText((String)inline);
                GenericBeanDefinition def = new GenericBeanDefinition();
                def.setSource((Object)child);
                def.setBeanClass(PigScript.class);
                String resource = null;
                if (StringUtils.hasText((String)location)) {
                    if (hasScriptInlined) {
                        context.getReaderContext().error("cannot specify both 'location' and a nested script; use only one", (Object)element);
                    }
                    resource = location;
                } else {
                    if (!hasScriptInlined) {
                        context.getReaderContext().error("no 'location' or nested script specified", (Object)element);
                    }
                    resource = BeanDefinitionBuilder.genericBeanDefinition(ByteArrayResource.class).addConstructorArgValue((Object)inline).addConstructorArgValue((Object)"resource for inlined script").getBeanDefinition();
                }
                def.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)resource, Resource.class.getName());
                String args = DomUtils.getChildElementValueByTagName((Element)child, (String)"arguments");
                if (args != null) {
                    AbstractBeanDefinition params = BeanDefinitionBuilder.genericBeanDefinition(LinkedProperties.class).addConstructorArgValue((Object)args).getBeanDefinition();
                    def.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)params);
                }
                defs.add(def);
            }
            return defs;
        }
        return Collections.emptyList();
    }
}

