/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Enumeration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;

public abstract class ResourceUtils {
    private static final Charset UTF8;

    public static Resource findContainingJar(Class<?> clazz) {
        return ResourceUtils.findContainingJar(clazz.getClassLoader(), clazz.getName().replace(".", "/") + ".class");
    }

    public static Resource findContainingJar(ClassLoader loader, String resourceName) {
        String binaryName = resourceName;
        try {
            Enumeration<URL> urls = loader.getResources(binaryName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                return new UrlResource(ResourceUtils.decode(url.getPath()).replaceAll("!.*$", ""));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot find jar for class " + resourceName, ex);
        }
        return null;
    }

    public static String decode(String source) {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return new String(bos.toByteArray(), UTF8);
    }

    static {
        try {
            UTF8 = Charset.forName("UTF-8");
        }
        catch (UnsupportedCharsetException uce) {
            throw new IllegalArgumentException("UTF-8 charset not found!");
        }
    }
}

