/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.cascading.HadoopFlowFactoryBean;
import org.springframework.data.hadoop.config.AbstractPropertiesConfiguredBeanDefinitionParser;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class CascadingFlowParser
extends AbstractPropertiesConfiguredBeanDefinitionParser {
    CascadingFlowParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return HadoopFlowFactoryBean.class;
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"write-dot".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        NamespaceUtils.setPropertyValue(element, builder, "write-dot", "writeDOT");
        String props = DomUtils.getTextValue((Element)element);
        if (StringUtils.hasText((String)props)) {
            builder.addPropertyValue("properties", (Object)props);
        }
    }
}

