/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.hbase.HbaseUtils;
import org.springframework.util.Assert;

public abstract class HbaseAccessor
implements InitializingBean {
    private String encoding;
    private Charset charset;
    private HTableInterfaceFactory tableFactory;
    private Configuration configuration;

    public HbaseAccessor() {
        this.charset = HbaseUtils.getCharset(this.encoding);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.configuration, (String)" a valid configuration is required");
        this.charset = HbaseUtils.getCharset(this.encoding);
    }

    public void setTableFactory(HTableInterfaceFactory tableFactory) {
        this.tableFactory = tableFactory;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HTableInterfaceFactory getTableFactory() {
        return this.tableFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

