/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.data.hadoop.mapreduce.JobExecutor;
import org.springframework.data.hadoop.mapreduce.JobUtils;

public class JobTasklet
extends JobExecutor
implements Tasklet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus execute(final StepContribution contribution, ChunkContext chunkContext) throws Exception {
        StepContext context = StepSynchronizationManager.getContext();
        final StepExecution stepExecution = context != null ? context.getStepExecution() : null;
        final AtomicBoolean done = new AtomicBoolean(false);
        JobExecutor.JobListener jobListener = new JobExecutor.JobListener(){

            @Override
            public Object beforeAction() {
                if (StepSynchronizationManager.getContext() == null) {
                    StepSynchronizationManager.register((StepExecution)stepExecution);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void afterAction(Object state) {
                if (Boolean.TRUE.equals(state)) {
                    StepSynchronizationManager.close();
                }
                done.set(true);
                AtomicBoolean atomicBoolean = done;
                synchronized (atomicBoolean) {
                    done.notify();
                }
            }

            @Override
            public void jobKilled(Job job) {
                JobTasklet.this.saveCounters(job, contribution);
                JobTasklet.saveJobStats(job, stepExecution);
            }

            @Override
            public void jobFinished(Job job) {
                JobTasklet.this.saveCounters(job, contribution);
                JobTasklet.saveJobStats(job, stepExecution);
            }
        };
        this.startJobs(jobListener);
        boolean stopped = false;
        if (this.isWaitForCompletion()) {
            while (!done.get() && !stopped) {
                if (stepExecution.isTerminateOnly()) {
                    this.log.info((Object)"Cancelling job tasklet");
                    stopped = true;
                    this.stopJobs(jobListener);
                    while (!done.get()) {
                        AtomicBoolean atomicBoolean = done;
                        synchronized (atomicBoolean) {
                            done.wait();
                        }
                    }
                    continue;
                }
                Thread.sleep(5500L);
            }
        }
        return RepeatStatus.FINISHED;
    }

    private void saveCounters(Job job, StepContribution contribution) {
        int i;
        Counters counters;
        block5: {
            counters = null;
            try {
                counters = job.getCounters();
            }
            catch (Exception ex) {
                if (!RuntimeException.class.isAssignableFrom(ex.getClass())) break block5;
                throw (RuntimeException)ex;
            }
        }
        if (counters == null) {
            return;
        }
        Counter count = counters.findCounter((Enum)Task.Counter.MAP_INPUT_RECORDS);
        for (i = 0; i < JobTasklet.safeLongToInt(count.getValue()); ++i) {
            contribution.incrementReadCount();
        }
        count = counters.findCounter((Enum)Task.Counter.MAP_SKIPPED_RECORDS);
        contribution.incrementReadSkipCount(JobTasklet.safeLongToInt(count.getValue()));
        count = counters.findCounter((Enum)Task.Counter.REDUCE_OUTPUT_RECORDS);
        contribution.incrementWriteCount(JobTasklet.safeLongToInt(count.getValue()));
        count = counters.findCounter((Enum)Task.Counter.REDUCE_SKIPPED_RECORDS);
        for (i = 0; i < JobTasklet.safeLongToInt(count.getValue()); ++i) {
            contribution.incrementWriteSkipCount();
        }
    }

    private static void saveJobStats(Job job, StepExecution stepExecution) {
        if (stepExecution == null) {
            return;
        }
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        String statusPrefix = "Job Status::";
        executionContext.put(statusPrefix + "ID", (Object)JobUtils.getJobId(job).toString());
        executionContext.put(statusPrefix + "Name", (Object)job.getJobName());
        executionContext.put(statusPrefix + "Tracking URL", (Object)job.getTrackingURL());
        executionContext.put(statusPrefix + "State", (Object)JobUtils.getStatus(job).toString());
        try {
            for (String cgName : job.getCounters().getGroupNames()) {
                CounterGroup group = job.getCounters().getGroup(cgName);
                for (Counter c : group) {
                    executionContext.put(group.getDisplayName().trim() + "::" + c.getDisplayName().trim(), (Object)c.getValue());
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }
}

