/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecJob;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.pig.PigOperations;
import org.springframework.data.hadoop.pig.PigScript;
import org.springframework.data.hadoop.pig.PigServerFactory;
import org.springframework.data.hadoop.pig.PigTemplate;
import org.springframework.util.CollectionUtils;

abstract class PigExecutor
implements InitializingBean {
    private PigServerFactory pigFactory;
    private PigOperations pigTemplate;
    private Collection<PigScript> scripts;

    PigExecutor() {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.pigFactory == null && this.pigTemplate == null) {
            throw new IllegalArgumentException("a PigServer factory or a PigTemplate is required");
        }
        if (this.pigTemplate == null) {
            this.pigTemplate = new PigTemplate(this.pigFactory);
        }
    }

    protected List<ExecJob> executePigScripts() {
        if (CollectionUtils.isEmpty(this.scripts)) {
            return Collections.emptyList();
        }
        return this.pigTemplate.executeScript(this.scripts);
    }

    public void setScripts(Collection<PigScript> scripts) {
        this.scripts = scripts;
    }

    public void setPigFactory(PigServerFactory pigFactory) {
        this.pigFactory = pigFactory;
    }

    public void setPigTemplate(PigOperations pigTemplate) {
        this.pigTemplate = pigTemplate;
    }
}

