/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.DefaultJdbcInterpreter;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalEntityDeleteWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityInsertWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityUpdateWriter;
import org.springframework.data.relational.core.conversion.RelationalEntityWriter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.event.AfterDeleteCallback;
import org.springframework.data.relational.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.relational.core.mapping.event.AfterLoadCallback;
import org.springframework.data.relational.core.mapping.event.AfterLoadEvent;
import org.springframework.data.relational.core.mapping.event.AfterSaveCallback;
import org.springframework.data.relational.core.mapping.event.AfterSaveEvent;
import org.springframework.data.relational.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteCallback;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.relational.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.relational.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcAggregateTemplate
implements JdbcAggregateOperations {
    private final ApplicationEventPublisher publisher;
    private final RelationalMappingContext context;
    private final RelationalConverter converter;
    private final Interpreter interpreter;
    private final RelationalEntityWriter jdbcEntityWriter;
    private final RelationalEntityDeleteWriter jdbcEntityDeleteWriter;
    private final RelationalEntityInsertWriter jdbcEntityInsertWriter;
    private final RelationalEntityUpdateWriter jdbcEntityUpdateWriter;
    private final DataAccessStrategy accessStrategy;
    private EntityCallbacks entityCallbacks = EntityCallbacks.create();

    public JdbcAggregateTemplate(ApplicationContext publisher, RelationalMappingContext context, RelationalConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationContext must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.accessStrategy = dataAccessStrategy;
        this.jdbcEntityWriter = new RelationalEntityWriter(context);
        this.jdbcEntityInsertWriter = new RelationalEntityInsertWriter(context);
        this.jdbcEntityUpdateWriter = new RelationalEntityUpdateWriter(context);
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.interpreter = new DefaultJdbcInterpreter(context, this.accessStrategy);
        this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)publisher));
    }

    public JdbcAggregateTemplate(ApplicationEventPublisher publisher, RelationalMappingContext context, RelationalConverter converter, DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null!");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.accessStrategy = dataAccessStrategy;
        this.jdbcEntityWriter = new RelationalEntityWriter(context);
        this.jdbcEntityInsertWriter = new RelationalEntityInsertWriter(context);
        this.jdbcEntityUpdateWriter = new RelationalEntityUpdateWriter(context);
        this.jdbcEntityDeleteWriter = new RelationalEntityDeleteWriter(context);
        this.interpreter = new DefaultJdbcInterpreter(context, this.accessStrategy);
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"Callbacks must not be null.");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <T> T save(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        Function<Object, AggregateChange> changeCreator = persistentEntity.isNew(instance) ? this::createInsertChange : this::createUpdateChange;
        return (T)this.store(instance, changeCreator, persistentEntity);
    }

    @Override
    public <T> T insert(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        return (T)this.store(instance, this::createInsertChange, persistentEntity);
    }

    @Override
    public <T> T update(T instance) {
        Assert.notNull(instance, (String)"Aggregate instance must not be null!");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(instance.getClass());
        return (T)this.store(instance, this::createUpdateChange, persistentEntity);
    }

    @Override
    public long count(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        return this.accessStrategy.count(domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        T entity = this.accessStrategy.findById(id, domainType);
        if (entity != null) {
            return this.triggerAfterLoad(id, entity);
        }
        return entity;
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        return this.accessStrategy.existsById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Iterable<T> all = this.accessStrategy.findAll(domainType);
        return this.triggerAfterLoad(all);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        Iterable<T> allById = this.accessStrategy.findAllById(ids, domainType);
        return this.triggerAfterLoad(allById);
    }

    public <S> void delete(S aggregateRoot, Class<S> domainType) {
        Assert.notNull(aggregateRoot, (String)"Aggregate root must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        IdentifierAccessor identifierAccessor = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType)).getIdentifierAccessor(aggregateRoot);
        this.deleteTree(identifierAccessor.getRequiredIdentifier(), aggregateRoot, domainType);
    }

    public <S> void deleteById(Object id, Class<S> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        this.deleteTree(id, null, domainType);
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        AggregateChange<?> change = this.createDeletingChange(domainType);
        change.executeWith(this.interpreter, this.context, this.converter);
    }

    private <T> T store(T aggregateRoot, Function<T, AggregateChange<T>> changeCreator, RelationalPersistentEntity<?> persistentEntity) {
        Assert.notNull(aggregateRoot, (String)"Aggregate instance must not be null!");
        aggregateRoot = this.triggerBeforeConvert(aggregateRoot);
        AggregateChange<T> change = changeCreator.apply(aggregateRoot);
        aggregateRoot = this.triggerBeforeSave(aggregateRoot, persistentEntity.getIdentifierAccessor(aggregateRoot).getIdentifier(), change);
        change.setEntity(aggregateRoot);
        change.executeWith(this.interpreter, this.context, this.converter);
        Object identifier = persistentEntity.getIdentifierAccessor(change.getEntity()).getIdentifier();
        Assert.notNull((Object)identifier, (String)"After saving the identifier must not be null!");
        return (T)this.triggerAfterSave(change.getEntity(), identifier, change);
    }

    private <T> void deleteTree(Object id, @Nullable T entity, Class<T> domainType) {
        AggregateChange<T> change = this.createDeletingChange(id, entity, domainType);
        entity = this.triggerBeforeDelete(entity, id, change);
        change.setEntity(entity);
        change.executeWith(this.interpreter, this.context, this.converter);
        this.triggerAfterDelete(entity, id, change);
    }

    private <T> AggregateChange<T> createInsertChange(T instance) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.SAVE, instance.getClass(), instance);
        this.jdbcEntityInsertWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> AggregateChange<T> createUpdateChange(T instance) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.SAVE, instance.getClass(), instance);
        this.jdbcEntityUpdateWriter.write(instance, aggregateChange);
        return aggregateChange;
    }

    private <T> AggregateChange<T> createDeletingChange(Object id, @Nullable T entity, Class<T> domainType) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.DELETE, domainType, entity);
        this.jdbcEntityDeleteWriter.write(id, aggregateChange);
        return aggregateChange;
    }

    private AggregateChange<?> createDeletingChange(Class<?> domainType) {
        AggregateChange aggregateChange = new AggregateChange(AggregateChange.Kind.DELETE, domainType, null);
        this.jdbcEntityDeleteWriter.write(null, aggregateChange);
        return aggregateChange;
    }

    private <T> Iterable<T> triggerAfterLoad(Iterable<T> all) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : all) {
            RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(e.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(e);
            result.add(this.triggerAfterLoad(identifierAccessor.getRequiredIdentifier(), e));
        }
        return result;
    }

    private <T> T triggerAfterLoad(Object id, T entity) {
        this.publisher.publishEvent((ApplicationEvent)new AfterLoadEvent(Identifier.of((Object)id), entity));
        return (T)this.entityCallbacks.callback(AfterLoadCallback.class, entity, new Object[0]);
    }

    private <T> T triggerBeforeConvert(T aggregateRoot) {
        return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, aggregateRoot, new Object[0]);
    }

    private <T> T triggerBeforeSave(T aggregateRoot, @Nullable Object id, AggregateChange<T> change) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(Identifier.ofNullable((Object)id), aggregateRoot, change));
        return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, aggregateRoot, new Object[]{change});
    }

    private <T> T triggerAfterSave(T aggregateRoot, Object id, AggregateChange<T> change) {
        Identifier.Specified identifier = Identifier.of((Object)id);
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(identifier, aggregateRoot, change));
        return (T)this.entityCallbacks.callback(AfterSaveCallback.class, aggregateRoot, new Object[0]);
    }

    private <T> void triggerAfterDelete(@Nullable T aggregateRoot, Object id, AggregateChange<?> change) {
        this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(Identifier.of((Object)id), Optional.ofNullable(aggregateRoot), change));
        if (aggregateRoot != null) {
            this.entityCallbacks.callback(AfterDeleteCallback.class, aggregateRoot, new Object[0]);
        }
    }

    @Nullable
    private <T> T triggerBeforeDelete(@Nullable T aggregateRoot, Object id, AggregateChange<?> change) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(Identifier.of((Object)id), Optional.ofNullable(aggregateRoot), change));
        if (aggregateRoot != null) {
            return (T)this.entityCallbacks.callback(BeforeDeleteCallback.class, aggregateRoot, new Object[]{change});
        }
        return null;
    }
}

