/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import liquibase.CatalogAndSchema;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropTableChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.core.yaml.YamlChangeLogParser;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.core.yaml.YamlChangeLogSerializer;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.jdbc.core.mapping.schema.Column;
import org.springframework.data.jdbc.core.mapping.schema.DefaultSqlTypeMapping;
import org.springframework.data.jdbc.core.mapping.schema.SchemaDiff;
import org.springframework.data.jdbc.core.mapping.schema.SqlTypeMapping;
import org.springframework.data.jdbc.core.mapping.schema.Table;
import org.springframework.data.jdbc.core.mapping.schema.TableDiff;
import org.springframework.data.jdbc.core.mapping.schema.Tables;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Predicates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LiquibaseChangeSetWriter {
    public static final String DEFAULT_AUTHOR = "Spring Data Relational";
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private SqlTypeMapping sqlTypeMapping = new DefaultSqlTypeMapping();
    private ChangeLogSerializer changeLogSerializer = new YamlChangeLogSerializer();
    private ChangeLogParser changeLogParser = new YamlChangeLogParser();
    private final Predicate<String> isLiquibaseTable = table -> table.toUpperCase(Locale.ROOT).startsWith("DATABASECHANGELOG");
    private final Comparator<String> nameComparator = LiquibaseChangeSetWriter.createComparator();
    private Predicate<RelationalPersistentEntity<?>> schemaFilter = Predicates.isTrue();
    private Predicate<String> dropTableFilter = Predicates.isFalse();
    private BiPredicate<String, String> dropColumnFilter = (table, column) -> false;

    private static Comparator<String> createComparator() {
        Collator instance = Collator.getInstance(Locale.ROOT);
        instance.setStrength(0);
        return instance::compare;
    }

    public LiquibaseChangeSetWriter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        this.mappingContext = mappingContext;
    }

    public void setSqlTypeMapping(SqlTypeMapping sqlTypeMapping) {
        Assert.notNull((Object)sqlTypeMapping, (String)"SqlTypeMapping must not be null");
        this.sqlTypeMapping = sqlTypeMapping;
    }

    public void setChangeLogSerializer(ChangeLogSerializer changeLogSerializer) {
        Assert.notNull((Object)changeLogSerializer, (String)"ChangeLogSerializer must not be null");
        this.changeLogSerializer = changeLogSerializer;
    }

    public void setChangeLogParser(ChangeLogParser changeLogParser) {
        Assert.notNull((Object)changeLogParser, (String)"ChangeLogParser must not be null");
        this.changeLogParser = changeLogParser;
    }

    public void setSchemaFilter(Predicate<RelationalPersistentEntity<?>> schemaFilter) {
        Assert.notNull(schemaFilter, (String)"Schema filter must not be null");
        this.schemaFilter = schemaFilter;
    }

    public void setDropTableFilter(Predicate<String> dropTableFilter) {
        Assert.notNull(dropTableFilter, (String)"Drop Column filter must not be null");
        this.dropTableFilter = dropTableFilter;
    }

    public void setDropColumnFilter(BiPredicate<String, String> dropColumnFilter) {
        Assert.notNull(dropColumnFilter, (String)"Drop Column filter must not be null");
        this.dropColumnFilter = dropColumnFilter;
    }

    public void writeChangeSet(Resource changeLogResource) throws IOException {
        this.writeChangeSet(changeLogResource, ChangeSetMetadata.create());
    }

    public void writeChangeSet(Resource changeLogResource, Database database) throws IOException, LiquibaseException {
        this.writeChangeSet(changeLogResource, ChangeSetMetadata.create(), database);
    }

    public void writeChangeSet(Resource changeLogResource, ChangeSetMetadata metadata) throws IOException {
        DatabaseChangeLog databaseChangeLog = this.getDatabaseChangeLog(changeLogResource.getFile(), null);
        ChangeSet changeSet = this.createChangeSet(metadata, databaseChangeLog);
        this.writeChangeSet(databaseChangeLog, changeSet, changeLogResource.getFile());
    }

    public void writeChangeSet(Resource changeLogResource, ChangeSetMetadata metadata, Database database) throws LiquibaseException, IOException {
        DatabaseChangeLog databaseChangeLog = this.getDatabaseChangeLog(changeLogResource.getFile(), database);
        ChangeSet changeSet = this.createChangeSet(metadata, database, databaseChangeLog);
        this.writeChangeSet(databaseChangeLog, changeSet, changeLogResource.getFile());
    }

    protected ChangeSet createChangeSet(ChangeSetMetadata metadata, DatabaseChangeLog databaseChangeLog) {
        return this.createChangeSet(metadata, this.initial(), databaseChangeLog);
    }

    protected ChangeSet createChangeSet(ChangeSetMetadata metadata, Database database, DatabaseChangeLog databaseChangeLog) throws LiquibaseException {
        return this.createChangeSet(metadata, this.differenceOf(database), databaseChangeLog);
    }

    private ChangeSet createChangeSet(ChangeSetMetadata metadata, SchemaDiff difference, DatabaseChangeLog databaseChangeLog) {
        ChangeSet changeSet = new ChangeSet(metadata.getId(), metadata.getAuthor(), false, false, "", "", "", databaseChangeLog);
        this.generateTableAdditionsDeletions(changeSet, difference);
        this.generateTableModifications(changeSet, difference);
        return changeSet;
    }

    private SchemaDiff initial() {
        Tables mappedEntities = Tables.from(this.mappingContext.getPersistentEntities().stream().filter(this.schemaFilter), this.sqlTypeMapping, null);
        return SchemaDiff.diff(mappedEntities, Tables.empty(), this.nameComparator);
    }

    private SchemaDiff differenceOf(Database database) throws LiquibaseException {
        Tables existingTables = this.getLiquibaseModel(database);
        Tables mappedEntities = Tables.from(this.mappingContext.getPersistentEntities().stream().filter(this.schemaFilter), this.sqlTypeMapping, database.getDefaultCatalogName());
        return SchemaDiff.diff(mappedEntities, existingTables, this.nameComparator);
    }

    private DatabaseChangeLog getDatabaseChangeLog(File changeLogFile, @Nullable Database database) throws IOException {
        ChangeLogParameters parameters;
        ChangeLogParameters changeLogParameters = parameters = database != null ? new ChangeLogParameters(database) : new ChangeLogParameters();
        if (!changeLogFile.exists()) {
            DatabaseChangeLog databaseChangeLog = new DatabaseChangeLog(changeLogFile.getName());
            if (database != null) {
                databaseChangeLog.setChangeLogParameters(parameters);
            }
            return databaseChangeLog;
        }
        try {
            File parentDirectory = changeLogFile.getParentFile();
            if (parentDirectory == null) {
                parentDirectory = new File("./");
            }
            DirectoryResourceAccessor resourceAccessor = new DirectoryResourceAccessor(parentDirectory);
            return this.changeLogParser.parse(changeLogFile.getName(), parameters, (ResourceAccessor)resourceAccessor);
        }
        catch (ChangeLogParseException ex) {
            throw new IOException(ex);
        }
    }

    private void generateTableAdditionsDeletions(ChangeSet changeSet, SchemaDiff difference) {
        for (Table table : difference.tableAdditions()) {
            CreateTableChange newTable = LiquibaseChangeSetWriter.changeTable(table);
            changeSet.addChange((Change)newTable);
        }
        for (Table table : difference.tableDeletions()) {
            if (!this.dropTableFilter.test(table.name())) continue;
            changeSet.addChange((Change)LiquibaseChangeSetWriter.dropTable(table));
        }
    }

    private void generateTableModifications(ChangeSet changeSet, SchemaDiff difference) {
        for (TableDiff table : difference.tableDiffs()) {
            List<Column> deletedColumns;
            if (!table.columnsToAdd().isEmpty()) {
                changeSet.addChange((Change)LiquibaseChangeSetWriter.addColumns(table));
            }
            if ((deletedColumns = this.getColumnsToDrop(table)).isEmpty()) continue;
            changeSet.addChange((Change)LiquibaseChangeSetWriter.dropColumns(table, deletedColumns));
        }
    }

    private List<Column> getColumnsToDrop(TableDiff table) {
        ArrayList<Column> deletedColumns = new ArrayList<Column>();
        for (Column column : table.columnsToDrop()) {
            if (!this.dropColumnFilter.test(table.table().name(), column.name())) continue;
            deletedColumns.add(column);
        }
        return deletedColumns;
    }

    private void writeChangeSet(DatabaseChangeLog databaseChangeLog, ChangeSet changeSet, File changeLogFile) throws IOException {
        ArrayList<ChangeSet> changes = new ArrayList<ChangeSet>(databaseChangeLog.getChangeSets());
        changes.add(changeSet);
        try (FileOutputStream fos = new FileOutputStream(changeLogFile);){
            this.changeLogSerializer.write(changes, (OutputStream)fos);
        }
    }

    private Tables getLiquibaseModel(Database targetDatabase) throws LiquibaseException {
        CatalogAndSchema[] schemas = new CatalogAndSchema[]{targetDatabase.getDefaultSchema()};
        SnapshotControl snapshotControl = new SnapshotControl(targetDatabase);
        DatabaseSnapshot snapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, targetDatabase, snapshotControl);
        Set tables = snapshot.get(liquibase.structure.core.Table.class);
        ArrayList<Table> existingTables = new ArrayList<Table>(tables.size());
        for (liquibase.structure.core.Table table : tables) {
            if (this.isLiquibaseTable.test(table.getName())) continue;
            Table tableModel = new Table(table.getSchema().getCatalogName(), table.getName());
            List columns = table.getColumns();
            for (liquibase.structure.core.Column column : columns) {
                String type = column.getType().toString();
                boolean nullable = column.isNullable();
                Column columnModel = new Column(column.getName(), type, nullable, false);
                tableModel.columns().add(columnModel);
            }
            existingTables.add(tableModel);
        }
        return new Tables(existingTables);
    }

    private static AddColumnChange addColumns(TableDiff table) {
        AddColumnChange addColumnChange = new AddColumnChange();
        addColumnChange.setSchemaName(table.table().schema());
        addColumnChange.setTableName(table.table().name());
        for (Column column : table.columnsToAdd()) {
            AddColumnConfig addColumn = LiquibaseChangeSetWriter.createAddColumnChange(column);
            addColumnChange.addColumn(addColumn);
        }
        return addColumnChange;
    }

    private static AddColumnConfig createAddColumnChange(Column column) {
        AddColumnConfig config = new AddColumnConfig();
        config.setName(column.name());
        config.setType(column.type());
        if (column.identity()) {
            config.setAutoIncrement(Boolean.valueOf(true));
        }
        return config;
    }

    private static DropColumnChange dropColumns(TableDiff table, Collection<Column> deletedColumns) {
        DropColumnChange dropColumnChange = new DropColumnChange();
        dropColumnChange.setSchemaName(table.table().schema());
        dropColumnChange.setTableName(table.table().name());
        ArrayList<ColumnConfig> dropColumns = new ArrayList<ColumnConfig>();
        for (Column column : deletedColumns) {
            ColumnConfig config = new ColumnConfig();
            config.setName(column.name());
            dropColumns.add(config);
        }
        dropColumnChange.setColumns(dropColumns);
        return dropColumnChange;
    }

    private static CreateTableChange changeTable(Table table) {
        CreateTableChange change = new CreateTableChange();
        change.setSchemaName(table.schema());
        change.setTableName(table.name());
        for (Column column : table.columns()) {
            ColumnConfig columnConfig = new ColumnConfig();
            columnConfig.setName(column.name());
            columnConfig.setType(column.type());
            ConstraintsConfig constraints = new ConstraintsConfig();
            constraints.setNullable(Boolean.valueOf(column.nullable()));
            if (column.identity()) {
                columnConfig.setAutoIncrement(Boolean.valueOf(true));
                constraints.setPrimaryKey(Boolean.valueOf(true));
            }
            columnConfig.setConstraints(constraints);
            change.addColumn(columnConfig);
        }
        return change;
    }

    private static DropTableChange dropTable(Table table) {
        DropTableChange change = new DropTableChange();
        change.setSchemaName(table.schema());
        change.setTableName(table.name());
        change.setCascadeConstraints(Boolean.valueOf(true));
        return change;
    }

    static interface ChangeSetMetadata {
        public static ChangeSetMetadata create() {
            return ChangeSetMetadata.ofAuthor(LiquibaseChangeSetWriter.DEFAULT_AUTHOR);
        }

        public static ChangeSetMetadata ofAuthor(String author) {
            return ChangeSetMetadata.of(Long.toString(System.currentTimeMillis()), author);
        }

        public static ChangeSetMetadata of(String identifier, String author) {
            return new DefaultChangeSetMetadata(identifier, author);
        }

        public String getId();

        public String getAuthor();
    }

    private record DefaultChangeSetMetadata(String id, String author) implements ChangeSetMetadata
    {
        private DefaultChangeSetMetadata {
            Assert.hasText((String)id, (String)"ChangeSet identifier must not be empty or null");
            Assert.hasText((String)author, (String)"Author must not be empty or null");
        }

        @Override
        public String getId() {
            return this.id();
        }

        @Override
        public String getAuthor() {
            return this.author();
        }
    }
}

