/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.PartTreeJdbcQuery;
import org.springframework.data.jdbc.repository.query.StringBasedJdbcQuery;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.event.AfterConvertCallback;
import org.springframework.data.relational.core.mapping.event.AfterConvertEvent;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class JdbcQueryLookupStrategy
implements QueryLookupStrategy {
    private static final Log LOG = LogFactory.getLog(JdbcQueryLookupStrategy.class);
    private final ApplicationEventPublisher publisher;
    @Nullable
    private final EntityCallbacks callbacks;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final Dialect dialect;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final NamedParameterJdbcOperations operations;
    @Nullable
    private final BeanFactory beanfactory;
    protected final QueryMethodEvaluationContextProvider evaluationContextProvider;

    JdbcQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanfactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContextPublisher must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvier must not be null");
        this.publisher = publisher;
        this.callbacks = callbacks;
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.operations = operations;
        this.beanfactory = beanfactory;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    JdbcQueryMethod getJdbcQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        return new JdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.context);
    }

    public static QueryLookupStrategy create(@Nullable QueryLookupStrategy.Key key, ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanFactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContextPublisher must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        CreateQueryLookupStrategy createQueryLookupStrategy = new CreateQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanFactory, evaluationContextProvider);
        DeclaredQueryLookupStrategy declaredQueryLookupStrategy = new DeclaredQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanFactory, evaluationContextProvider);
        QueryLookupStrategy.Key cleanedKey = key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
        LOG.debug((Object)String.format("Using the queryLookupStrategy %s", cleanedKey));
        switch (cleanedKey) {
            case CREATE: {
                return createQueryLookupStrategy;
            }
            case USE_DECLARED_QUERY: {
                return declaredQueryLookupStrategy;
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanFactory, createQueryLookupStrategy, declaredQueryLookupStrategy, evaluationContextProvider);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s", key));
    }

    RelationalMappingContext getContext() {
        return this.context;
    }

    JdbcConverter getConverter() {
        return this.converter;
    }

    Dialect getDialect() {
        return this.dialect;
    }

    NamedParameterJdbcOperations getOperations() {
        return this.operations;
    }

    @Nullable
    BeanFactory getBeanFactory() {
        return this.beanfactory;
    }

    RowMapper<Object> createMapper(Class<?> returnedObjectType) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance(returnedObjectType, (ConversionService)this.converter.getConversionService());
        }
        return this.determineDefaultMapper(returnedObjectType);
    }

    private RowMapper<?> determineDefaultMapper(Class<?> returnedObjectType) {
        RowMapper<?> configuredQueryMapper = this.queryMappingConfiguration.getRowMapper(returnedObjectType);
        if (configuredQueryMapper != null) {
            return configuredQueryMapper;
        }
        EntityRowMapper defaultEntityRowMapper = new EntityRowMapper((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(returnedObjectType), this.converter);
        return new PostProcessingRowMapper(defaultEntityRowMapper);
    }

    static class CreateQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        CreateQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanfactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanfactory, evaluationContextProvider);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            JdbcQueryMethod queryMethod = this.getJdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries);
            return new PartTreeJdbcQuery(this.getContext(), queryMethod, this.getDialect(), this.getConverter(), this.getOperations(), this::createMapper);
        }
    }

    static class DeclaredQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        DeclaredQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanfactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanfactory, evaluationContextProvider);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            JdbcQueryMethod queryMethod = this.getJdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries);
            if (namedQueries.hasQuery(queryMethod.getNamedQueryName()) || queryMethod.hasAnnotatedQuery()) {
                if (queryMethod.hasAnnotatedQuery() && queryMethod.hasAnnotatedQueryName()) {
                    LOG.warn((Object)String.format("Query method %s is annotated with both, a query and a query name; Using the declared query", method));
                }
                StringBasedJdbcQuery query = new StringBasedJdbcQuery(queryMethod, this.getOperations(), this::createMapper, this.getConverter(), this.evaluationContextProvider);
                query.setBeanFactory(this.getBeanFactory());
                return query;
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s", method));
        }
    }

    static class CreateIfNotFoundQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        CreateIfNotFoundQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanfactory, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanfactory, evaluationContextProvider);
            Assert.notNull((Object)createStrategy, (String)"CreateQueryLookupStrategy must not be null");
            Assert.notNull((Object)lookupStrategy, (String)"DeclaredQueryLookupStrategy must not be null");
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
        }
    }

    class PostProcessingRowMapper<T>
    implements RowMapper<T> {
        private final RowMapper<T> delegate;

        PostProcessingRowMapper(RowMapper<T> delegate) {
            this.delegate = delegate;
        }

        public T mapRow(ResultSet rs, int rowNum) throws SQLException {
            Object entity = this.delegate.mapRow(rs, rowNum);
            if (entity != null) {
                JdbcQueryLookupStrategy.this.publisher.publishEvent((ApplicationEvent)new AfterConvertEvent(entity));
                if (JdbcQueryLookupStrategy.this.callbacks != null) {
                    return (T)JdbcQueryLookupStrategy.this.callbacks.callback(AfterConvertCallback.class, entity, new Object[0]);
                }
            }
            return (T)entity;
        }
    }
}

