/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public abstract class JpaQueryExecution {
    public Object execute(AbstractJpaQuery query, Object[] values) {
        Assert.notNull((Object)query);
        Assert.notNull((Object)values);
        try {
            return this.doExecute(query, values);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    protected abstract Object doExecute(AbstractJpaQuery var1, Object[] var2);

    static class ModifyingExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public ModifyingExecution(JpaQueryMethod method, EntityManager em) {
            Class<?> returnType = method.getReturnType();
            boolean isVoid = Void.TYPE.equals(returnType) || Void.class.equals(returnType);
            boolean isInt = Integer.TYPE.equals(returnType) || Integer.class.equals(returnType);
            Assert.isTrue((isInt || isVoid ? 1 : 0) != 0, (String)"Modifying queries can only use void or int/Integer as return type!");
            this.em = em;
        }

        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            int result = query.createQuery(values).executeUpdate();
            if (this.em != null) {
                this.em.clear();
            }
            return result;
        }
    }

    static class SingleEntityExecution
    extends JpaQueryExecution {
        SingleEntityExecution() {
        }

        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            return query.createQuery(values).getSingleResult();
        }
    }

    static class PagedExecution
    extends JpaQueryExecution {
        private final Parameters parameters;

        public PagedExecution(Parameters parameters) {
            this.parameters = parameters;
        }

        protected Object doExecute(AbstractJpaQuery repositoryQuery, Object[] values) {
            Query projection = repositoryQuery.createCountQuery(values);
            Long total = (Long)projection.getSingleResult();
            Query query = repositoryQuery.createQuery(values);
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
            return new PageImpl(query.getResultList(), accessor.getPageable(), total.longValue());
        }
    }

    static class CollectionExecution
    extends JpaQueryExecution {
        CollectionExecution() {
        }

        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            return query.createQuery(values).getResultList();
        }
    }
}

