/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain.support;

import java.util.Arrays;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.domain.AuditorAware;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.util.StringUtils;

public class AuditingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public static final String BEAN_CONFIGURER_ASPECT_BEAN_NAME = "org.springframework.context.config.internalBeanConfigurerAspect";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        try {
            beanFactory.getBeanDefinition(BEAN_CONFIGURER_ASPECT_BEAN_NAME);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            throw new IllegalStateException("Invalid auditing setup! Make sure you've used @EnableJpaAuditing or <jpa:auditing /> correctly!", o_O);
        }
        for (String beanName : this.getEntityManagerFactoryBeanNames((ListableBeanFactory)beanFactory)) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            definition.setDependsOn(StringUtils.addStringToArray((String[])definition.getDependsOn(), (String)BEAN_CONFIGURER_ASPECT_BEAN_NAME));
        }
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, AuditorAware.class, (boolean)true, (boolean)false)) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            definition.setLazyInit(true);
        }
    }

    private Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, EntityManagerFactory.class, (boolean)true, (boolean)false)));
        for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, AbstractEntityManagerFactoryBean.class, (boolean)true, (boolean)false)) {
            names.add(factoryBeanName.substring(1));
        }
        return names;
    }
}

